/*
 * Decompiled with CFR 0.152.
 */
package uws.service.actions;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.JobList;
import uws.job.user.JobOwner;
import uws.service.UWSService;
import uws.service.UWSUrl;
import uws.service.actions.UWSAction;
import uws.service.log.UWSLog;

public class DestroyJob
extends UWSAction {
    private static final long serialVersionUID = 1L;

    public DestroyJob(UWSService u) {
        super(u);
    }

    @Override
    public String getName() {
        return "Destroy Job";
    }

    @Override
    public String getDescription() {
        return "Lets stopping the specified job, removing it from its jobs list and destroying all its associated resources. (URL: {baseUWS_URL}/{jobListName}/{job-id}, Method: HTTP-DELETE, No parameter) or (URL: {baseUWS_URL}/{jobListName}/{job-id}, Method: HTTP-POST, Parameter: ACTION=DELETE)";
    }

    @Override
    public boolean match(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request) throws UWSException {
        return urlInterpreter.hasJobList() && urlInterpreter.hasJob() && urlInterpreter.getAttributes().length == 0 && (request.getMethod().equalsIgnoreCase("delete") || request.getMethod().equalsIgnoreCase("post") && UWSToolBox.hasParameter("ACTION", "DELETE", request, false));
    }

    @Override
    public boolean apply(UWSUrl urlInterpreter, JobOwner user, HttpServletRequest request, HttpServletResponse response) throws UWSException, IOException {
        boolean destroyed;
        JobList jobsList = this.getJobsList(urlInterpreter);
        try {
            destroyed = jobsList.destroyJob(urlInterpreter.getJobId(), user);
        }
        catch (UWSException ue) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, urlInterpreter, "DESTROY_JOB", "Can not destroy the job \"" + urlInterpreter.getJobId() + "\"!", ue);
            throw ue;
        }
        this.uws.redirect(urlInterpreter.listJobs(jobsList.getName()).getRequestURL(), request, user, this.getName(), response);
        return destroyed;
    }
}

