/*
 * Decompiled with CFR 0.152.
 */
package vo.parameter;

import java.util.Map;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import vo.parameter.Circle;
import vo.parameter.Parser;
import vo.parameter.Polygon;
import vo.parameter.Range;

public class Pos {
    private static final String ARG_POS = "POS";
    private static final String ARG_CIRCLE = "CIRCLE";
    private static final String ARG_POLYGON = "POLYGON";
    private static final String ARG_POSSYS = "POSSYS";
    protected static final Logger LOGGER = Logger.getLogger(Pos.class.getName());
    public System system;
    public Shape shape;
    public Circle circle;
    public Range range;
    public Polygon polygon;

    public static Pos parsePos(Map<String, String[]> params, String defaultSystem) {
        String valuePos = Parser.getSingleValue(params, ARG_POS);
        String valueCircle = Parser.getSingleValue(params, ARG_CIRCLE);
        String valuePolygon = Parser.getSingleValue(params, ARG_POLYGON);
        String valuePosSystem = Parser.getSingleValue(params, ARG_POSSYS);
        if (valuePosSystem == null) {
            valuePosSystem = Parser.getSingleValue(params, "skysystem", defaultSystem);
        }
        Pos pos = null;
        if (valuePos != null && valueCircle == null && valuePolygon == null) {
            pos = new Pos(valuePos, valuePosSystem);
            LOGGER.finest(pos.toString());
        } else if (valuePos == null && valueCircle != null && valuePolygon == null) {
            Circle circle = new Circle(valueCircle);
            LOGGER.finest(circle.toString());
            pos = new Pos(circle, valuePosSystem);
        } else if (valuePos == null && valueCircle == null && valuePolygon != null) {
            Polygon polygon = new Polygon(valuePolygon);
            LOGGER.finest(polygon.toString());
            pos = new Pos(polygon, valuePosSystem);
        } else if (valuePos == null && valueCircle == null && valuePolygon == null) {
            pos = Pos.vlkbReq_getCircleRect(params, valuePosSystem);
        } else {
            throw new IllegalArgumentException("Exactly one of POS | CIRCLE | POLYGON must be given.");
        }
        return pos;
    }

    public static Pos parsePosCirclePolygonFromJson(String jsonString, String defaultSystem) {
        Pos pos;
        block6: {
            JSONParser parser = new JSONParser();
            pos = null;
            try {
                String valuePosSystem;
                JSONObject jObj = (JSONObject)parser.parse(jsonString);
                JSONObject jPos = (JSONObject)jObj.get((Object)"pos");
                JSONObject jCircle = (JSONObject)jObj.get((Object)"circle");
                JSONObject jPolygon = (JSONObject)jObj.get((Object)"polygon");
                String sysString = (String)jObj.get((Object)"possys");
                String string = valuePosSystem = sysString == null ? defaultSystem : sysString;
                if (jPos != null && jCircle == null && jPolygon == null) {
                    pos = Pos.parsePosFromJson(jPos.toString(), valuePosSystem);
                    LOGGER.finest(pos.toString());
                    break block6;
                }
                if (jPos == null && jCircle != null && jPolygon == null) {
                    Circle circle = Circle.parseCircleFromJson(jCircle.toString());
                    LOGGER.finest(circle.toString());
                    pos = new Pos(circle, valuePosSystem);
                    break block6;
                }
                if (jPos == null && jCircle == null && jPolygon != null) {
                    Polygon polygon = Polygon.parsePolygonFromJson(jPolygon.toString());
                    LOGGER.finest(polygon.toString());
                    pos = new Pos(polygon, valuePosSystem);
                    break block6;
                }
                if (jPos == null && jCircle == null && jPolygon == null) {
                    LOGGER.finest("Json parse Pos vlkb-legacy not implemented");
                    break block6;
                }
                throw new IllegalArgumentException("Exactly one of POS | CIRCLE | POLYGON must be given.");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return pos;
    }

    public static Pos parsePosFromJson(String jsonString, String posSystem) {
        Pos pos;
        block5: {
            JSONParser parser = new JSONParser();
            pos = null;
            try {
                JSONObject jObj = (JSONObject)parser.parse(jsonString);
                JSONObject jCircle = (JSONObject)jObj.get((Object)"circle");
                JSONObject jRange = (JSONObject)jObj.get((Object)"range");
                JSONObject jPolygon = (JSONObject)jObj.get((Object)"polygon");
                if (jCircle != null) {
                    pos = new Pos(Circle.parseCircleFromJson(jCircle.toString()), posSystem);
                    break block5;
                }
                if (jRange != null) {
                    pos = new Pos(Range.parseRangeFromJson(jRange.toString()), posSystem);
                    break block5;
                }
                if (jPolygon != null) {
                    pos = new Pos(Polygon.parsePolygonFromJson(jPolygon.toString()), posSystem);
                    break block5;
                }
                throw new IllegalArgumentException("Valid POS shape (circle or range or polygon) was not found in this json: " + jsonString);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return pos;
    }

    public Pos(String value, String valuePosSystem) {
        LOGGER.fine("trace: " + value);
        this.parsePos(value);
        this.system = System.valueOf(valuePosSystem);
    }

    public Pos(Circle circle, String valuePosSystem) {
        this.shape = Shape.CIRCLE;
        this.circle = circle;
        this.system = System.valueOf(valuePosSystem);
    }

    public Pos(Range range, String valuePosSystem) {
        this.shape = Shape.RANGE;
        this.range = range;
        this.system = System.valueOf(valuePosSystem);
    }

    public Pos(Polygon polygon, String valuePosSystem) {
        this.shape = Shape.POLYGON;
        this.polygon = polygon;
        this.system = System.valueOf(valuePosSystem);
    }

    private void parsePos(String str) {
        String[] strArr = str.strip().split(" +", 2);
        if (strArr.length <= 1) {
            throw new IllegalArgumentException("POS value must have more then one space-separated elements but had " + strArr.length + " elements)");
        }
        this.shape = Shape.valueOf(strArr[0].strip());
        String value = strArr[1].strip();
        switch (this.shape) {
            case CIRCLE: {
                this.circle = new Circle(value);
                break;
            }
            case RANGE: {
                this.range = new Range(value);
                break;
            }
            case POLYGON: {
                this.polygon = new Polygon(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape.toString());
            }
        }
    }

    public void setSystem(String strSystem) {
        this.system = System.valueOf(strSystem);
    }

    public String toString() {
        String shapeStr;
        switch (this.shape) {
            case CIRCLE: {
                shapeStr = this.circle.toString();
                break;
            }
            case RANGE: {
                shapeStr = this.range.toString();
                break;
            }
            case POLYGON: {
                shapeStr = this.polygon.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape.toString());
            }
        }
        return "POS=" + shapeStr + "&POSSYS=" + this.system.toString();
    }

    public String toJsonString() {
        JSONObject j = new JSONObject();
        j.put((Object)"possys", (Object)this.system.toString());
        JSONObject jShape = new JSONObject();
        if (this.circle != null) {
            jShape.put((Object)"circle", (Object)this.circle.toJsonObject());
        }
        if (this.range != null) {
            jShape.put((Object)"range", (Object)this.range.toJsonObject());
        }
        if (this.polygon != null) {
            jShape.put((Object)"polygon", (Object)this.polygon.toJsonObject());
        }
        j.put((Object)"pos", (Object)jShape);
        return j.toString();
    }

    public String lonBoundsString() {
        String shapeStr;
        switch (this.shape) {
            case CIRCLE: {
                shapeStr = this.circle.lonBoundsString();
                break;
            }
            case RANGE: {
                shapeStr = this.range.lonBoundsString();
                break;
            }
            case POLYGON: {
                shapeStr = new Range(this.polygon).latBoundsString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape.toString());
            }
        }
        return shapeStr;
    }

    public String latBoundsString() {
        String shapeStr;
        switch (this.shape) {
            case CIRCLE: {
                shapeStr = this.circle.latBoundsString();
                break;
            }
            case RANGE: {
                shapeStr = this.range.latBoundsString();
                break;
            }
            case POLYGON: {
                shapeStr = new Range(this.polygon).latBoundsString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Valid POS shape is CIRCLE or RANGE or POLYGON but was: " + this.shape.toString());
            }
        }
        return shapeStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Pos vlkbReq_getCircleRect(Map<String, String[]> params, String valuePosSystem) {
        Pos pos = null;
        String l_value = Parser.getSingleValue(params, "l");
        String b_value = Parser.getSingleValue(params, "b");
        if (l_value != null && b_value != null) {
            String r_value = Parser.getSingleValue(params, "r");
            if (r_value != null) {
                Circle circle = new Circle(l_value + " " + b_value + " " + r_value);
                return new Pos(circle, valuePosSystem);
            }
            String dl_value = Parser.getSingleValue(params, "dl");
            String db_value = Parser.getSingleValue(params, "db");
            if (dl_value == null) throw new IllegalArgumentException("one of 'r' or '(dl,db)' pair must be provided to designate sky area");
            if (db_value == null) throw new IllegalArgumentException("one of 'r' or '(dl,db)' pair must be provided to designate sky area");
            double l = Double.parseDouble(l_value);
            double b = Double.parseDouble(b_value);
            double dl = Double.parseDouble(dl_value);
            double db = Double.parseDouble(db_value);
            Range range = new Range(l, b, dl, db);
            return new Pos(range, valuePosSystem);
        }
        if (l_value != null) {
            if (b_value == null) throw new IllegalArgumentException("VLKB sky position center (l,b): l or b is missing");
        }
        if (l_value != null) return pos;
        if (b_value == null) return pos;
        throw new IllegalArgumentException("VLKB sky position center (l,b): l or b is missing");
    }

    public static enum System {
        ICRS,
        GALACTIC,
        GRID,
        NONE;

    }

    public static enum Shape {
        CIRCLE,
        RANGE,
        POLYGON;

    }
}

