
#include <string.h>

#include "fix_header.hpp"
#include "io.hpp"

char * fix_header(char * header)
{
   LOG_trace(__func__);

   char * p;


   /* Fix 1 VELO-LSR not standard by PaperIII
    * it is FITS-CLASS encoding from 'CLASS' sw package: AST manual p 438..439
    * AST man p438: FITS-CLASS encoding recognized if VELO-LST & DELTAV keyword present
    * Then AST gives error msg:
    * ! astRead(FitsChan): FITS-CLASS keyword CTYPE3 has value "VELO-LSR" - CLASS support in AST only includes "FREQ" axes.
    * FIXME LSR should go to new card: SPECSYS = LSRK
    * VELO-LSR at least in HI_VGPS MOS_017*
    * ast-8.2.0 have fixed this
    * if uodated to ast-8.4.0 so remove VELO-LSR replacement
    */ 
   p = strstr(header, "VELO-LSR");
   if(p)memcpy(p,"VELO    ",8);


   /* HI_VGPS encodes rest frq as FREQ0 :
    * FIXME how to deal with this ? other surveys nay use FREQ0 for something else
    * p = strstr(header, "FREQ0   ");
    * if(p)strncpy(p,"RESTFRQ ",8);
    */


   // Fix 2 VELOCITY not standard by PaperIII
   p = strstr(header, "VELOCITY");
   if(p)memcpy(p,"VELO    ",8);


   // Fix 3 velocity axis unit capital, should be small letters (?see PaperIII) HI_VGPS MOS_017
   p = strstr(header, "M/S");
   if(p)memcpy(p,"m/s",3);


   return header;
}

