/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.tile;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardBuilder;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.compression.algorithm.api.ICompressOption;
import nom.tam.fits.compression.algorithm.api.ICompressorControl;
import nom.tam.fits.compression.provider.CompressorProvider;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.tile.TileCompressionOperation;
import nom.tam.image.compression.tile.TileCompressionType;
import nom.tam.image.compression.tile.TileCompressorInitialisation;
import nom.tam.image.compression.tile.TileDecompressorInitialisation;
import nom.tam.image.tile.operation.AbstractTiledImageOperation;
import nom.tam.image.tile.operation.TileArea;
import nom.tam.util.type.PrimitiveTypeHandler;

public class TiledImageCompressionOperation
extends AbstractTiledImageOperation<TileCompressionOperation> {
    private String compressAlgorithm;
    private final BinaryTable binaryTable;
    private ByteBuffer compressedWholeArea;
    private ICompressorControl compressorControl;
    private ICompressorControl gzipCompressorControl;
    private String quantAlgorithm;
    private ICompressOption imageOptions;

    private static void addColumnToTable(BinaryTableHDU hdu, Object column, String columnName) throws FitsException {
        if (column != null) {
            hdu.setColumnName(hdu.addColumn(column) - 1, columnName, null);
        }
    }

    private static void setNullEntries(Object column, Object defaultValue) {
        if (column != null) {
            for (int index = 0; index < Array.getLength(column); ++index) {
                if (Array.get(column, index) != null) continue;
                Array.set(column, index, defaultValue);
            }
        }
    }

    public TiledImageCompressionOperation(BinaryTable binaryTable) {
        super(TileCompressionOperation.class);
        this.binaryTable = binaryTable;
    }

    public void compress(BinaryTableHDU hdu) throws FitsException {
        this.processAllTiles();
        this.writeColumns(hdu);
        this.writeHeader(hdu.getHeader());
    }

    public ICompressOption compressOptions() {
        this.initializeCompressionControl();
        return this.imageOptions;
    }

    public Buffer decompress() {
        Buffer decompressedWholeArea = this.getBaseType().newBuffer(this.getBufferSize());
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            tileOperation.setWholeImageBuffer(decompressedWholeArea);
        }
        this.processAllTiles();
        decompressedWholeArea.rewind();
        return decompressedWholeArea;
    }

    public void forceNoLoss(int x, int y, int width, int heigth) {
        TileArea tileArea = new TileArea().start(x, y).end(x + width, y + heigth);
        for (TileCompressionOperation operation : (TileCompressionOperation[])this.getTileOperations()) {
            if (!operation.getArea().intersects(tileArea)) continue;
            operation.forceNoLoss(true);
        }
    }

    public TiledImageCompressionOperation prepareUncompressedData(Buffer buffer) {
        this.compressedWholeArea = ByteBuffer.wrap(new byte[this.getBaseType().size() * this.getBufferSize()]);
        this.createTiles(new TileCompressorInitialisation(this, buffer));
        this.compressedWholeArea.rewind();
        return this;
    }

    public TiledImageCompressionOperation read(Header header) throws FitsException {
        this.readPrimaryHeaders(header);
        this.setCompressAlgorithm(header.findCard(Compression.ZCMPTYPE));
        this.setQuantAlgorithm(header.findCard(Compression.ZQUANTIZ));
        this.createTiles(new TileDecompressorInitialisation(this, this.getNullableColumn(header, Object[].class, "UNCOMPRESSED_DATA"), this.getNullableColumn(header, Object[].class, "COMPRESSED_DATA"), this.getNullableColumn(header, Object[].class, "GZIP_COMPRESSED_DATA"), header));
        this.readCompressionHeaders(header);
        return this;
    }

    public void readPrimaryHeaders(Header header) throws FitsException {
        this.readBaseType(header);
        this.readAxis(header);
        this.readTileAxis(header);
    }

    public TiledImageCompressionOperation setCompressAlgorithm(HeaderCard compressAlgorithmCard) {
        this.compressAlgorithm = compressAlgorithmCard.getValue();
        return this;
    }

    public TiledImageCompressionOperation setQuantAlgorithm(HeaderCard quantAlgorithmCard) {
        this.quantAlgorithm = quantAlgorithmCard != null ? quantAlgorithmCard.getValue() : null;
        return this;
    }

    private <T> T getNullableColumn(Header header, Class<T> class1, String columnName) throws FitsException {
        for (int i = 1; i <= this.binaryTable.getNCols(); ++i) {
            String val = header.getStringValue(Standard.TTYPEn.n(i));
            if (val == null || !val.trim().equals(columnName)) continue;
            return class1.cast(this.binaryTable.getColumn(i - 1));
        }
        return null;
    }

    private void initializeCompressionControl() {
        if (this.compressorControl == null) {
            this.compressorControl = CompressorProvider.findCompressorControl(this.quantAlgorithm, this.compressAlgorithm, this.getBaseType().primitiveClass());
            if (this.compressorControl == null) {
                throw new IllegalStateException("Found no compressor control for compression algorithm:" + this.compressAlgorithm + " (quantize algorithm = " + this.quantAlgorithm + ", base type = " + this.getBaseType().primitiveClass() + ")");
            }
            this.initImageOptions();
        }
    }

    private void initImageOptions() {
        this.imageOptions = this.compressorControl.option();
        this.initializeQuantAlgorithm();
        this.imageOptions.getCompressionParameters().initializeColumns(this.getNumberOfTileOperations());
    }

    private void processAllTiles() {
        ExecutorService threadPool = FitsFactory.threadPool();
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            tileOperation.execute(threadPool);
        }
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            tileOperation.waitForResult();
        }
    }

    private void readAxis(Header header) throws FitsException {
        if (this.areAxesDefined()) {
            int naxis = header.getIntValue(Compression.ZNAXIS);
            int[] axes = new int[naxis];
            for (int i = 1; i <= naxis; ++i) {
                int axisValue;
                axes[i - 1] = axisValue = header.getIntValue(Compression.ZNAXISn.n(i), -1);
                if (axes[i - 1] != -1) continue;
                throw new FitsException("Required ZNAXISn not found");
            }
            this.setAxes(axes);
        }
    }

    private void readBaseType(Header header) {
        if (this.getBaseType() == null) {
            this.setBaseType(PrimitiveTypeHandler.valueOf(header.getIntValue(Compression.ZBITPIX)));
        }
    }

    private void readCompressionHeaders(Header header) {
        this.compressOptions().getCompressionParameters().getValuesFromHeader(header);
    }

    private void readTileAxis(Header header) {
        if (this.areTileAxesDefined()) {
            int[] tileAxes = new int[this.getNAxes()];
            Arrays.fill(tileAxes, 1);
            tileAxes[0] = -1;
            for (int i = 1; i <= tileAxes.length; ++i) {
                HeaderCard card = header.findCard(Compression.ZTILEn.n(i));
                if (card == null) continue;
                tileAxes[i - 1] = card.getValue(Integer.class, -1);
            }
            this.setTileAxes(tileAxes);
        }
    }

    private <T> Object setInColumn(Object column, boolean predicate, TileCompressionOperation tileOperation, Class<T> clazz, T value) {
        if (predicate) {
            if (column == null) {
                column = Array.newInstance(clazz, this.getNumberOfTileOperations());
            }
            Array.set(column, tileOperation.getTileIndex(), value);
        }
        return column;
    }

    private void writeColumns(BinaryTableHDU hdu) throws FitsException {
        Object compressedColumn = null;
        Object uncompressedColumn = null;
        Object gzipColumn = null;
        for (TileCompressionOperation tileOperation : (TileCompressionOperation[])this.getTileOperations()) {
            TileCompressionType compression = tileOperation.getCompressionType();
            byte[] compressedData = tileOperation.getCompressedData();
            compressedColumn = this.setInColumn(compressedColumn, compression == TileCompressionType.COMPRESSED, tileOperation, byte[].class, compressedData);
            gzipColumn = this.setInColumn(gzipColumn, compression == TileCompressionType.GZIP_COMPRESSED, tileOperation, byte[].class, compressedData);
            uncompressedColumn = this.setInColumn(uncompressedColumn, compression == TileCompressionType.UNCOMPRESSED, tileOperation, byte[].class, compressedData);
        }
        TiledImageCompressionOperation.setNullEntries(compressedColumn, new byte[0]);
        TiledImageCompressionOperation.setNullEntries(gzipColumn, new byte[0]);
        TiledImageCompressionOperation.setNullEntries(uncompressedColumn, new byte[0]);
        TiledImageCompressionOperation.addColumnToTable(hdu, compressedColumn, "COMPRESSED_DATA");
        TiledImageCompressionOperation.addColumnToTable(hdu, gzipColumn, "GZIP_COMPRESSED_DATA");
        TiledImageCompressionOperation.addColumnToTable(hdu, uncompressedColumn, "UNCOMPRESSED_DATA");
        this.imageOptions.getCompressionParameters().addColumnsToTable(hdu);
        ((BinaryTable)hdu.getData()).fillHeader(hdu.getHeader());
    }

    private void writeHeader(Header header) throws FitsException {
        HeaderCardBuilder cardBuilder = header.card(Compression.ZBITPIX).value(this.getBaseType().bitPix()).card(Compression.ZCMPTYPE).value(this.compressAlgorithm);
        int[] tileAxes = this.getTileAxes();
        for (int i = 1; i <= tileAxes.length; ++i) {
            cardBuilder.card(Compression.ZTILEn.n(i)).value(tileAxes[i - 1]);
        }
        this.compressOptions().getCompressionParameters().setValuesInHeader(header);
    }

    protected BinaryTable getBinaryTable() {
        return this.binaryTable;
    }

    protected ByteBuffer getCompressedWholeArea() {
        return this.compressedWholeArea;
    }

    protected ICompressorControl getCompressorControl() {
        this.initializeCompressionControl();
        return this.compressorControl;
    }

    protected ICompressorControl getGzipCompressorControl() {
        if (this.gzipCompressorControl == null) {
            this.gzipCompressorControl = CompressorProvider.findCompressorControl(null, "GZIP_1", this.getBaseType().primitiveClass());
        }
        return this.gzipCompressorControl;
    }

    protected void initializeQuantAlgorithm() {
        if (this.quantAlgorithm != null) {
            try {
                Header header = new Header();
                header.addValue((IFitsHeader)Compression.ZQUANTIZ, this.quantAlgorithm);
                this.imageOptions.getCompressionParameters().getValuesFromHeader(header);
            }
            catch (HeaderCardException e) {
                throw new IllegalStateException("this should not happen", e);
            }
        }
    }
}

