
#include "service_string.hpp"
#include <stdexcept>

using namespace std;

skysystem to_skysystem(std::string str)
{
   if(str.compare("GALACTIC") == 0) return skysystem::GALACTIC;
   else if(str.compare("ICRS") == 0) return skysystem::ICRS;
   else throw invalid_argument("string must be GALACTIC or ICRS but was " + str);
}

specsystem to_specsystem(std::string str)
{
   if(str.compare("NONE") == 0) return specsystem::NONE;
   else if(str.compare("VELO_LSRK") == 0) return specsystem::VELO_LSRK;
   else if(str.compare("WAVE_Barycentric") == 0) return specsystem::WAVE_Barycentric;
   else throw invalid_argument("string must be NONE, VELO_LSRK or WAVE_Barycentric but was " + str);
}



specsystem to_specsystem(int i)// special case for legacy interface, remove later
{
   switch(i)
   {
      case 0: return specsystem::NONE;
      case 1: return specsystem::VELO_LSRK;
      case 2: return specsystem::WAVE_Barycentric;
      default: return specsystem::NONE;
   }
}

