#!/bin/bash

set +e
LOG_FILE=/tmp/entrypoint.log

{
date
whoami
env

#########################################################################
echo "run-time config (compose.yaml):"
echo "SECURITY            : "$SECURITY
echo "AUTH_DB_*           : "$AUTH_DB_URI" ["$AUTH_DB_SCHEMA"] "$AUTH_DB_USERNAME" / "$AUTH_DB_PASSWORD

echo "ACCESS_CONTEXT_ROOT : "$ACCESS_CONTEXT_ROOT
echo "RESPONSE_FORMAT     : "$RESPONSE_FORMAT
echo "URL_CUTOUTS         : "$URL_CUTOUTS
echo "RESOLVER_DB_*       : "$RESOLVER_DB_URI" ["$RESOLVER_DB_SCHEMA"] "$RESOLVER_DB_USERNAME" / "$RESOLVER_DB_PASSWORD
echo "VLKBOBSCORE_PG_URI  : "$VLKBOBSCORE_PG_URI

echo "build-time config'd (Dockefile):"
echo "INST_DIR   : "$INST_DIR
echo "WEBAPP_DIR : "$WEBAPP_DIR

echo "JAVA_HOME       : "$JAVA_HOME
echo "CATALINA_BASE   : "$CATALINA_BASE
echo "CATALINA_HOME   : "$CATALINA_HOME
echo "CATALINA_TMPDIR : "$CATALINA_TMPDIR
#########################################################################

## configure vlkb-tools

if test -n "$VLKBOBSCORE_PG_URI"
then
   echo "pg_uri=$VLKBOBSCORE_PG_URI" >> $INST_DIR/etc/vlkb-obscore/datasets.conf
   echo "pg_schema=datasets"         >> $INST_DIR/etc/vlkb-obscore/datasets.conf
fi

## configure VLKB access

cp $WEBAPP_DIR/META-INF/context.xml $CATALINA_BASE/conf/Catalina/localhost/$ACCESS_CONTEXT_ROOT.xml

echo "fits_path_surveys=/srv/surveys" > $WEBAPP_DIR/WEB-INF/classes/cutout.properties

{ # write cutout.properties

   case $RESPONSE_FORMAT in
      application/fits)
         ;;
      "application/fits;createfile=yes")
         echo "default_response_format=$RESPONSE_FORMAT"
         echo "fits_path_cutouts=/srv/cutouts"
         QUEUE_NAME=dockervlkb$ACCESS_CONTEXT_ROOT
         ;;
      application/x-vlkb*)
         echo "default_response_format=$RESPONSE_FORMAT"
         echo "fits_path_cutouts=/srv/cutouts"
         echo "fits_url_cutouts=$URL_CUTOUTS"
         echo "surveys_metadata_abs_pathname=/srv/surveys/survey_populate.csv"
         QUEUE_NAME=dockervlkb$ACCESS_CONTEXT_ROOT
         echo "default_sky_system=GALACTIC"
         echo "default_spec_system=VELO_LSRK"
         echo "show_duration=yes"
         ;;
   esac

   if test -n "$QUEUE_NAME"
   then
      echo "amqp_host_name=localhost"
      echo "amqp_port=5672"
      echo "amqp_routing_key=$QUEUE_NAME"
   fi

   if test -n "$RESOLVER_DB_URI"
   then
      echo "db_uri=$RESOLVER_DB_URI"
      echo "db_schema=$RESOLVER_DB_SCHEMA"
      echo "db_user_name=$RESOLVER_DB_USERNAME"
      echo "db_password=$RESOLVER_DB_PASSWORD"
   fi

} >> $WEBAPP_DIR/WEB-INF/classes/cutout.properties


if test -n "$QUEUE_NAME"
then
   service rabbitmq-server start
   $INST_DIR/bin/vlkbd_exec.sh localhost $QUEUE_NAME $INST_DIR/etc/vlkbd/datasets.conf
fi


#### Security

case $SECURITY in
   ia2token)
      cd $WEBAPP_DIR/WEB-INF/ && rm -f web.xml && cp web-cutout-$SECURITY.xml web.xml && cd -
      cp /etc/pki/tls/server-connector.xml /etc/tomcat9/
      cp /etc/pki/tls/auth*.properties $WEBAPP_DIR/WEB-INF/classes/
      rm -f $WEBAPP_DIR/WEB-INF/lib/jjwt-*0.12*.jar
      ;;
   iamtoken)
      cd $WEBAPP_DIR/WEB-INF/ && rm -f web.xml && cp web-cutout-$SECURITY.xml web.xml && cd -
      cp /etc/pki/tls/server-connector.xml /etc/tomcat9/
      cp /etc/pki/tls/iamtoken.properties $WEBAPP_DIR/WEB-INF/classes/
      rm -f $WEBAPP_DIR/WEB-INF/lib/jjwt-*0.11*.jar
      ;;
   *)
      echo "Security not configured, runs open."
      ;;
esac

#########################################################################

date

} 1> $LOG_FILE 2>&1

/usr/libexec/tomcat9/tomcat-start.sh &

wait -n

