## vlkb-soda

is a web-application to access astronomical data stored in FITS-files.
It implements SODA IVOA recommendation v1.0 (https://ivoa.net/documents/SODA/20170517/index.html).

Docker image is available in this repository and cean be launched by the following compose.yaml

```yaml
version: '3' 

services:

  soda:
    container_name: soda-vlkb
    image: git.ia2.inaf.it:5050/vialactea/vlkb-soda/soda:1.6.3
    ports:
      - 18019:8080
    environment:
      - ACCESS_CONTEXT_ROOT=ska#datasets
    volumes:
      - /srv/ska/surveys:/srv/surveys:z,ro
    restart: always


  soda-ssl:
    container_name: soda-ssl-vlkb
    image: git.ia2.inaf.it:5050/vialactea/vlkb-soda/soda:1.6.3
    ports:
      - 18025:8443
    environment:
      - SECURITY=ia2token
      - ACCESS_CONTEXT_ROOT=ska#datasets
    volumes:
      - /srv/ska/surveys:/srv/surveys:z,ro
    restart: always
```


## SODA for VLKB

Additionally to SODAv1 it also provides VLKB-specific functions:

- the filtering paramters (POS, BAND) can be given in GALACTIC and VELO-LSRK-km/s coordinates systems
- supports non-WCS cuts by pixels grid
- inserts additional metadata (RESTFREQ, CUNIT) if not present in FITS-headers
- can create and hold a cut-file server-side for later download, and
- provides count of undefined values in the cut-file


The service consists of

- **vlkb-soda** web-application and associated **vlkbd** daemon to access FITS file contents based on VO SODA
- **vlkb** command line utility to perform some of the functionalities of the web-applications on command line

It can be used with vlkb-siav2 to provide complete data discovery and access service:
- **vlkb-siav2** web-application and associated **vlkb-obscore** command line tool based on VO ObsCore table

The vlkb-siav2 web-app is available from https://ict.inaf.it/gitlab/ViaLactea/vlkb-siav2 .

Dockerized version is available from this projects registry git.ia2.inaf.it:5050/vialactea/vlkb-soda.

## Installation

There are rpm, deb and war packages avaialable for Debian, CentOS and Fedora.

### Install from packages (rpm/deb and war)

There is a war-package for the cutout web-application

- vlkb-soda-X.Y.Z.war

And two packages for linux executables (deb or rpm)

- vlkbd-X.Y.Z.deb implements the cutout engine and should be installed together with vlkb-cutout-\*.war
- vlkb-X.Y.Z.deb is a optional utility

Additionally optional vlkb-obscore utility for the vlkb-search web-app:
- vlkb-obscore-X.Y.Z.deb is a optional tool to create ObsCore table for vlkb-search-\*.war

To download version X.Y, add one of the above package names to

```bash
FIXME   curl -O --header "PRIVATE-TOKEN: <security-token>"  "https://ict.inaf.it/gitlab/api/v4/projects/79/packages/generic/vlkb-datasets/X.Y/<package-name>"

```


