

#include "json_request.hpp"
#include "io.hpp"

#include "cutout.hpp"
#include "cutout_nljson.hpp"
#include "mcutout.hpp"
#include "mcutout_nljson.hpp"


#include <stdexcept>
#include "json.hpp"

#include <iostream>

using json = nlohmann::json;
const bool ASSERTS = true;

using namespace std;




NLOHMANN_JSON_SERIALIZE_ENUM( service, {
      {MCUTOUT,"MCUTOUT"},
      {MERGEF, "MERGEF"},
      {MERGE1, "MERGE1"},
      {MERGE2, "MERGE2"},
      {MERGE3, "MERGE3"},
      {SUBIMG, "SUBIMG"}
      });


json_request::json_request(string request_json)
{
   LOG_trace(__func__);

   m_jservice = json::parse(request_json, nullptr, ASSERTS);
   m_service = m_jservice.at("service");

   LOG_STREAM << m_jservice.dump() << endl;
}

struct coordinates json_request::coordinates() {return m_jservice.at("coordinates");}

vector<struct cut_param_s> json_request::cut_params()
{
   LOG_trace(__func__);

   vector<struct cut_param_s> cut_pars;
   json cuts = m_jservice.at("cuts");
   cut_pars = cuts.get<std::vector<struct cut_param_s>>();

   return cut_pars;
}

std::vector<struct fits_card> json_request::extra_cards()
{
   vector<struct fits_card> cards;
   if(m_jservice.contains("extra_cards"))
   {
      json jcards = m_jservice.at("extra_cards");
      cards = jcards.get<std::vector<struct fits_card>>();
   }
   return cards;
}


std::vector<std::string> json_request::get_pol()
{
   vector<string> str;
   if(m_jservice.contains("pol"))
   {
      json j = m_jservice.at("pol");
      str = j.get<std::vector<string>>();
   }
   return str;
}

