/*
 * Decompiled with CFR 0.152.
 */
package uws;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISO8601Format {
    public static boolean displayTimeZone = true;
    public static boolean displayMilliseconds = false;
    public static String targetTimeZone = "UTC";
    protected static final DecimalFormat oneDigitFmt = new DecimalFormat("0");
    protected static final DecimalFormat twoDigitsFmt = new DecimalFormat("00");
    protected static final DecimalFormat threeDigitsFmt = new DecimalFormat("000");
    private static final String ISO8601_TIME_REGEX = "((T| )(\\d{2})(:?(\\d{2})(:?(\\d{2})(\\.?(\\d{1,}))?)?)?(Z|(\\+|-)(\\d{2})(:?(\\d{2}))?)?)?";
    private static final Pattern ISO8601_PATTERN = Pattern.compile("(\\d{4})(-?((\\d{2})(-?(\\d{2})((T| )(\\d{2})(:?(\\d{2})(:?(\\d{2})(\\.?(\\d{1,}))?)?)?(Z|(\\+|-)(\\d{2})(:?(\\d{2}))?)?)?)?|(\\d{3})((T| )(\\d{2})(:?(\\d{2})(:?(\\d{2})(\\.?(\\d{1,}))?)?)?(Z|(\\+|-)(\\d{2})(:?(\\d{2}))?)?)?|W(\\d{2})(-?(\\d)((T| )(\\d{2})(:?(\\d{2})(:?(\\d{2})(\\.?(\\d{1,}))?)?)?(Z|(\\+|-)(\\d{2})(:?(\\d{2}))?)?)?)?))?");

    public static String format(Date date) {
        return ISO8601Format.format(date.getTime(), targetTimeZone, displayTimeZone, displayMilliseconds);
    }

    public static String format(long date) {
        return ISO8601Format.format(date, targetTimeZone, displayTimeZone, displayMilliseconds);
    }

    public static String format(long date, boolean withTimeZone) {
        return ISO8601Format.format(date, targetTimeZone, withTimeZone, displayMilliseconds);
    }

    public static String formatInUTC(long date) {
        return ISO8601Format.format(date, "UTC", displayTimeZone, displayMilliseconds);
    }

    public static String formatInUTC(long date, boolean withTimeZone) {
        return ISO8601Format.format(date, "UTC", withTimeZone, displayMilliseconds);
    }

    protected static synchronized String format(long date, String targetTimeZone, boolean withTimeZone, boolean withMillisec) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date);
        if (targetTimeZone != null && targetTimeZone.length() > 0) {
            cal.setTimeZone(TimeZone.getTimeZone(targetTimeZone));
        } else {
            cal.setTimeZone(TimeZone.getTimeZone(ISO8601Format.targetTimeZone));
        }
        StringBuffer buf = new StringBuffer();
        buf.append(cal.get(1)).append('-');
        buf.append(twoDigitsFmt.format(cal.get(2) + 1)).append('-');
        buf.append(twoDigitsFmt.format(cal.get(5)));
        buf.append('T').append(twoDigitsFmt.format(cal.get(11))).append(':');
        buf.append(twoDigitsFmt.format(cal.get(12))).append(':');
        buf.append(twoDigitsFmt.format(cal.get(13)));
        if (withMillisec) {
            buf.append('.').append(threeDigitsFmt.format(cal.get(14)));
        }
        if (withTimeZone) {
            boolean negative;
            int tzOffset = (cal.get(15) + cal.get(16)) / 60000;
            boolean bl = negative = tzOffset < 0;
            if (negative) {
                tzOffset *= -1;
            }
            int hours = tzOffset / 60;
            int minutes = tzOffset - hours * 60;
            if (hours == 0 && minutes == 0) {
                buf.append('Z');
            } else {
                buf.append(negative ? (char)'-' : '+');
                buf.append(twoDigitsFmt.format(hours)).append(':');
                buf.append(twoDigitsFmt.format(minutes));
            }
        }
        return buf.toString();
    }

    public static final Date parseToDate(String strDate) throws ParseException {
        return new Date(ISO8601Format.parse(strDate));
    }

    public static final void main(String[] args) throws Throwable {
        System.out.println("Date in millis: " + ISO8601Format.parse("2015-12-11"));
    }

    public static synchronized long parse(String strDate) throws ParseException {
        Matcher m = ISO8601_PATTERN.matcher(strDate);
        if (m.matches()) {
            GregorianCalendar cal = new GregorianCalendar();
            int timeGroupInd = -1;
            cal.setTimeZone(TimeZone.getTimeZone("UTC"));
            cal.set(1, Integer.parseInt(m.group(1)));
            if (m.group(4) != null) {
                cal.set(2, ISO8601Format.getMonth(m.group(4)));
                if (m.group(5) != null) {
                    cal.set(5, ISO8601Format.getDayOfMonth(m.group(6), cal));
                } else {
                    cal.set(5, 1);
                }
                timeGroupInd = 7;
            } else if (m.group(21) != null) {
                cal.set(6, ISO8601Format.getDayOfYear(m.group(21), cal));
                timeGroupInd = 22;
            } else if (m.group(36) != null) {
                cal.set(3, ISO8601Format.getWeekOfYear(m.group(36), cal));
                if (m.group(37) != null) {
                    cal.set(7, ISO8601Format.getDayOfWeek(m.group(38)));
                }
                timeGroupInd = 39;
            } else {
                cal.set(2, 0);
                cal.set(5, 1);
            }
            if (timeGroupInd > 0 && m.group(timeGroupInd) != null) {
                cal.set(11, ISO8601Format.getHours(m.group(timeGroupInd + 2)));
                if (m.group(timeGroupInd + 3) != null) {
                    cal.set(12, ISO8601Format.getMinutes(m.group(timeGroupInd + 4)));
                    if (m.group(timeGroupInd + 5) != null) {
                        cal.set(13, ISO8601Format.getSeconds(m.group(timeGroupInd + 6)));
                        if (m.group(timeGroupInd + 7) != null) {
                            cal.set(14, twoDigitsFmt.parse(m.group(timeGroupInd + 8)).intValue());
                        } else {
                            cal.set(14, 0);
                        }
                    } else {
                        cal.set(13, 0);
                        cal.set(14, 0);
                    }
                } else {
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                }
            } else {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
            }
            if (timeGroupInd > 0 && m.group(timeGroupInd + 9) != null && !m.group(timeGroupInd + 9).equals("Z")) {
                int sign = m.group(timeGroupInd + 10).equals("-") ? 1 : -1;
                cal.add(11, sign * ISO8601Format.getHours(m.group(timeGroupInd + 11)));
                if (m.group(timeGroupInd + 12) != null) {
                    cal.add(12, sign * ISO8601Format.getMinutes(m.group(timeGroupInd + 13)));
                }
            }
            return cal.getTimeInMillis();
        }
        throw new ParseException("Invalid date format: \"" + strDate + "\"! An ISO8601 date was expected.", 0);
    }

    private static final int getDayOfYear(String str, GregorianCalendar cal) throws ParseException {
        int dayOfYear = threeDigitsFmt.parse(str).intValue();
        if (dayOfYear < 1 || dayOfYear > cal.getActualMaximum(6)) {
            throw new ParseException("Incorrect day of year: " + dayOfYear + "! An integer between 1 and " + cal.getActualMaximum(6) + " was expected.", -1);
        }
        return dayOfYear;
    }

    private static final int getDayOfMonth(String str, GregorianCalendar cal) throws ParseException {
        int dayOfMonth = twoDigitsFmt.parse(str).intValue();
        if (dayOfMonth < 1 || dayOfMonth > cal.getActualMaximum(5)) {
            throw new ParseException("Incorrect day of month: " + dayOfMonth + "! An integer between 1 and " + cal.getActualMaximum(5) + " was expected.", -1);
        }
        return dayOfMonth;
    }

    private static final int getDayOfWeek(String str) throws ParseException {
        int dayOfWeek = oneDigitFmt.parse(str).intValue();
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new ParseException("Incorrect day of week: " + dayOfWeek + "! An integer between 1 (for Monday) and 7 (for Sunday) was expected.", -1);
        }
        dayOfWeek = dayOfWeek == 7 ? 1 : ++dayOfWeek;
        return dayOfWeek;
    }

    private static final int getWeekOfYear(String str, GregorianCalendar cal) throws ParseException {
        int weekOfYear = twoDigitsFmt.parse(str).intValue();
        if (weekOfYear < 1 || weekOfYear > cal.getActualMaximum(3)) {
            throw new ParseException("Incorrect week of year value: " + weekOfYear + "! An integer between 1 and " + cal.getActualMaximum(3) + " was expected.", -1);
        }
        return weekOfYear;
    }

    private static final int getMonth(String str) throws ParseException {
        int month = twoDigitsFmt.parse(str).intValue();
        if (month < 1 || month > 12) {
            throw new ParseException("Incorrect month value: " + month + "! An integer between 1 and 12 was expected.", -1);
        }
        return month - 1;
    }

    private static final int getHours(String str) throws ParseException {
        int hours = twoDigitsFmt.parse(str).intValue();
        if (hours < 0 || hours > 24) {
            throw new ParseException("Incorrect hour value: " + hours + "! An integer between 0 and 24 was expected.", -1);
        }
        return hours;
    }

    private static final int getMinutes(String str) throws ParseException {
        int minutes = twoDigitsFmt.parse(str).intValue();
        if (minutes < 0 || minutes > 60) {
            throw new ParseException("Incorrect minute value: " + minutes + "! An integer between 0 and 60 was expected.", -1);
        }
        return minutes;
    }

    private static final int getSeconds(String str) throws ParseException {
        int seconds = twoDigitsFmt.parse(str).intValue();
        if (seconds < 0 || seconds > 60) {
            throw new ParseException("Incorrect second value: " + seconds + "! An integer between 0 and 60 was expected.", -1);
        }
        return seconds;
    }
}

