
import java.util.logging.Logger;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

import vo.parameter.*;

// The cutout-args:
// CutResult doCutoutFile(
//          String id,
//          Pos pos, Band band, Time time, Pol pol, String pixels,
//          boolean countNullValues)
//
// The result:
//class CutResult
//{
//   String fileName;
//   long fileSize;
//   NullValueCount nullValueCount;
//   String pixels; <- from WCS-conversion (not input)
//}
//
//class NullValueCount
//{
//   double percent;
//   long nullCount;
//   long totalCount;
//}
//


// vlkb-soda has:
//class Coord
//{
//   Pos  pos;
//   Band band;
//   Time time;
//   Pol  pol;
//   String pixels;
//}


// FIXME or call this Jdl.java ?

class CutArgs
{
   static final Logger LOGGER = Logger.getLogger(CutArgs.class.getName());

   static CutArgs[] parseCutArgsArr(String jsonString)
   {
      LOGGER.fine("trace : " + jsonString);

      List<CutArgs> argsList = new ArrayList<CutArgs>();

      JSONParser parser = new JSONParser();
      try
      {
         // FIXME explicit converions: should check type first
         JSONArray a = (JSONArray) parser.parse(jsonString);

         for (Object o : a)
         {
            // FIXME check type
            JSONObject jElem = (JSONObject) o;
            LOGGER.finest("jElem: " + jElem.toString());

            CutArgs args = new CutArgs();

            args.id = (String) jElem.get("id");
            //if(args.id == null)
            //  args.id = (String) jElem.get("pubdid");

            Object jCNV = jElem.get("countNullVals");
            args.countNullValues = (jCNV == null) ? false : (Boolean) jElem.get("countNullVals");

            // FIXME first check if array (or null?) and then cast

            String defaultPosSystem = "GALACTIC";
            Pos pos = Pos.parsePosFromJson(jElem, defaultPosSystem);
            args.pos = pos;

            String defaultBandSystem = "VELO_LSRK";
            Band band = Band.parseBandFromJson(jElem, defaultBandSystem);
            args.band = band;

            // TBD:  * legacy is parsed inside POS and BAND, not here -> do modif
            //       * still missing TIME and POL and ID and (?)countNullValues

            LOGGER.warning("VLKB: legacy param parsing from MCutout jsodn-JDL disabled");
/* FIXME removes VLKB_legacy param parsing from MCutout JDL
 
            // FIXME explicit converions: check if exists and then check type first
            JSONObject jCoord = (JSONObject) jElem.get("coord");

            if(jCoord != null)
            {
               // legacy
               LOGGER.finest("TEST: " + jCoord.toString());

               args.lon = (Double) jCoord.get("l");
               args.lat = (Double) jCoord.get("b");
               args.radius = (Double) jCoord.get("r");
               args.dl = (Double) jCoord.get("dl");
               args.db = (Double) jCoord.get("db");
               args.vl = (Double) jCoord.get("vl");
               args.vu = (Double) jCoord.get("vu");
            }

            // FIXME missing:
            Pos.System skySystem = Pos.System.GALACTIC;//"GALACTIC";
            Band.System specSystem = Band.System.VELO_LSRK;//"VELO_LSRK";


            // convert:

            if(args.lon != null && args.lat != null && args.radius != null)
            {
               Circle circle = new Circle(args.lon, args.lat, args.radius);
               args.pos = new Pos(circle, skySystem);
            }

            if(args.lon != null && args.lat != null && args.dl != null && args.db != null)
            {
               //Range range(args.lon - args.dl/2.0, args.lon + args.dl/2.0,
               //            args.lat - args.db/2.0, args.lat + args.db/2.0);,
               Range range = new Range(args.lon, args.lat, args.dl, args.db);
               args.pos = new Pos(range, skySystem);
            }

            if(args.vl != null && args.vu != null)
            {
               args.band = new Band(args.vl, args.vu, specSystem);
            }
*/
            argsList.add(args);
         }
      }
      catch(ParseException e)
      {
         e.printStackTrace();
      }

      return argsList.toArray(new CutArgs[0]);
   }

   String id;
   Pos pos;
   Band band;
   Time time;
   Pol pol;
   String pixels;
   // FitxCard[] extraCards; ???
   Boolean countNullValues;

   // legacy
   //Double lon, lat, radius, dl, db, vl, vu; // double throws except if json-null
}

