

class Ivoid
{
   private String localPart;

   public Ivoid(String ivoid)
   {
      if(ivoid.startsWith("ivo://"))
      {
         int lastQ = ivoid.lastIndexOf("?");
         if( lastQ < 0 )
         {
            throw new IllegalArgumentException("IVOID must contain '?' but none found in: " + ivoid);
         }
         else
         {
            localPart = ivoid.substring(lastQ + 1);// +1: skip '?'
            // throws IndexOutOfBoundsException
            // if lastQ = str.length -> returns "" (empty string)
         }
      }
      else
      {
         throw new IllegalArgumentException("IVOID must start with 'ivo://' but it is: " + ivoid);
      }
   }

   public String getLocalPart(){ return localPart; }
}
