#ifndef CUTOUT_NLJSON_HPP
#define CUTOUT_NLJSON_HPP

#include "json.hpp"
#include "cutout.hpp"

using json = nlohmann::json;

void from_json(const json& j, position& p);
void from_json(const json& j, band& p);
void from_json(const json& j, time_axis& p);

void to_json(json& j, const nullvals_count_s& p);
void to_json(json& j, const cutout_res_s& p);
void to_json(json& j, const fits_card& p);
void from_json(const json& j, fits_card& p);

void from_json(const json& j, uint_bounds& p);

void to_json(json& j, const coordinates& p);
void from_json(const json& j, coordinates& p);

#endif

