
import java.util.logging.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.io.PrintWriter;

/* for Csv-loadSubsurveys * /
import com.opencsv.*;
import com.opencsv.exceptions.*;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
*/



class IamTokenSettings
{
   private static final Logger LOGGER = Logger.getLogger("IamTokenSettings");

   static final String VLKB_PROPERTIES = "iamtoken.properties";

   public static class Security
   {
      String jwksEndpoint;
      String introspectEndpoint;
      String clientName;
      String clientPassword;
      String resourceId;

      String non_authn_username = null;
   }

   public Security security;


   // will not start without config-file
   // no reasonable code-defaults can be invented
   public static IamTokenSettings getInstance()
   {
      try
      {
         InputStream ins =
            IamTokenSettings.class.getClassLoader().getResourceAsStream(VLKB_PROPERTIES);

         if (ins != null)
         {
            Properties properties = new Properties();
            properties.load(ins);

            Security  security = loadSecurity(properties);

            return new IamTokenSettings(security);
         }
         else
         {
            throw new IllegalStateException(VLKB_PROPERTIES + " not found in classpath");
         }

      }
      catch(IOException ex)
      {
         throw new IllegalStateException("Error while loading " + VLKB_PROPERTIES + " file", ex);
      }
   }

   public String getIntrospectUrl()  { return this.security.introspectEndpoint; }
   public String getClientName()     { return this.security.clientName; }
   public String getClientPassword() { return this.security.clientPassword; }

/* FIXME all  fail if reurned string is null  */


   private IamTokenSettings(Security security)
   {
      this.security  = security;
   }


   private static Security loadSecurity(Properties properties)
   {
      Security security = new IamTokenSettings.Security();
      security.jwksEndpoint = getPropertyStriped(properties, "jwks_url");
      security.introspectEndpoint = getPropertyStriped(properties, "introspect");
      security.clientName = getPropertyStriped(properties, "client_name");
      security.clientPassword = getPropertyStriped(properties, "client_password");
      security.resourceId = getPropertyStriped(properties, "resource_id");
      security.non_authn_username = getPropertyStriped(properties, "non_authenticated_username");
      return security;
   }


   private static String getPropertyStriped(Properties properties, String setting)
   {
      String st = properties.getProperty(setting);
      if(st != null) return st.strip();
      else return st;
   }


}

