
#include "SqlSchema.hpp"


using namespace std;

SqlSchema::SqlSchema()
{
   reset();
}


void SqlSchema::reset(void)
{
   obscoreRow
      = {
         {dataproduct_type, "dataproduct_type   VARCHAR"},
         {calib_level,      "calib_level        INTEGER     NOT NULL"},
         {obs_collection,   "obs_collection     VARCHAR     NOT NULL"},
         {obs_title,        "obs_title          VARCHAR"},
         {obs_id,           "obs_id             VARCHAR     NOT NULL"},
         {obs_publisher_id, "obs_publisher_did  VARCHAR     PRIMARY KEY"},
         {bib_reference,    "bib_reference      VARCHAR"},
         {data_rights,      "data_rights        VARCHAR"},
         {access_url,       "access_url         TEXT"},
         {access_format,    "access_format      VARCHAR"},
         {access_estsize,   "access_estsize     BIGINT"},
         {target_name,      "target_name        VARCHAR"},
         {s_ra,             "s_ra               double precision"},
         {s_dec,            "s_dec              double precision"},
         {s_fov,            "s_fov              double precision"},
         {s_region,         "s_region           VARCHAR"},
         {s_region_galactic,"s_region_galactic  VARCHAR"},
         {s_xel1,           "s_xel1             bigint"},
         {s_xel2,           "s_xel2             bigint"},
         {s_resolution,     "s_resolution       double precision"},
         {t_min,            "t_min              double precision"},
         {t_max,            "t_max              double precision"},
         {t_exptime,        "t_exptime          double precision"},
         {t_resolution,     "t_resolution       double precision"},
         {t_xel,            "t_xel              bigint"},
         {em_min,           "em_min             double precision"},
         {em_max,           "em_max             double precision"},
         {vel_min,          "vel_min            double precision"},
         {vel_max,          "vel_max            double precision"},
         {em_res_power,     "em_res_power       double precision"},
         {em_xel,           "em_xel             bigint"},
         {o_ucd,            "o_ucd              VARCHAR"},
         {pol_states,       "pol_states         VARCHAR"},
         {pol_xel,          "pol_xel            bigint"},
         {facility_name,    "facility_name      VARCHAR"},
         {instrument_name,  "instrument_name    VARCHAR"},
         {coordinates,      "coordinates        spoint"},
         {polygon_region_galactic,   "polygon_region_galactic     spoly"},
         {polygon_region,   "polygon_region     spoly"},
         {proposal_id,      "proposal_id        VARCHAR"},
         {policy ,          "policy             auth_policy NOT NULL"},
         {groups,           "groups             TEXT[]      NULL"}
      };


   initCols();
}


void SqlSchema::initCols(void)
{
   m_columns[obscore]         = "(" + obscoreRow.concat_val_first_word() + ")";
};



void SqlSchema::appendRow(void)
{
   m_values[obscore]     += "(" + obscoreRow.concat_val_all()  + "),";
};





// skip last character
string SqlSchema::skl(string str)
{
   return str.substr(0, str.size() - 1);
}

