/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Array;
import nom.tam.util.BufferPointer;
import nom.tam.util.type.PrimitiveType;
import nom.tam.util.type.PrimitiveTypeHandler;

public abstract class BufferDecoder {
    private final BufferPointer sharedBuffer;

    public BufferDecoder(BufferPointer sharedBuffer) {
        this.sharedBuffer = sharedBuffer;
    }

    protected abstract void checkBuffer(int var1) throws IOException;

    protected abstract int eofCheck(EOFException var1, int var2, int var3, int var4) throws EOFException;

    protected int read(boolean[] b, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                b[i] = this.readBoolean();
            }
            return length;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 1);
        }
    }

    protected int read(byte[] buf, int offset, int len) throws IOException {
        this.checkBuffer(-1);
        int total = 0;
        while (len > 0) {
            if (this.sharedBuffer.bufferOffset < this.sharedBuffer.bufferLength) {
                int get = len;
                if (this.sharedBuffer.bufferOffset + get > this.sharedBuffer.bufferLength) {
                    get = this.sharedBuffer.bufferLength - this.sharedBuffer.bufferOffset;
                }
                System.arraycopy(this.sharedBuffer.buffer, this.sharedBuffer.bufferOffset, buf, offset, get);
                len -= get;
                this.sharedBuffer.bufferOffset += get;
                offset += get;
                total += get;
                continue;
            }
            try {
                if (len > this.sharedBuffer.buffer.length) {
                    this.checkBuffer(this.sharedBuffer.buffer.length);
                    continue;
                }
                this.checkBuffer(len);
            }
            catch (EOFException e) {
                if (this.sharedBuffer.bufferLength > 0) {
                    System.arraycopy(this.sharedBuffer.buffer, 0, buf, offset, this.sharedBuffer.bufferLength);
                    total += this.sharedBuffer.bufferLength;
                    this.sharedBuffer.bufferLength = 0;
                }
                if (total == 0) {
                    throw e;
                }
                return total;
            }
        }
        return total;
    }

    protected int read(char[] c, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                c[i] = this.readChar();
            }
            return length * 2;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 2);
        }
    }

    protected int read(double[] d, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                d[i] = Double.longBitsToDouble(this.readLong());
            }
            return length * 8;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 8);
        }
    }

    protected int read(float[] f, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                f[i] = Float.intBitsToFloat(this.readInt());
            }
            return length * 4;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 4);
        }
    }

    protected int read(int[] i, int start, int length) throws IOException {
        int ii;
        try {
            for (ii = start; ii < start + length; ++ii) {
                i[ii] = this.readInt();
            }
            return length * 4;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, ii, 4);
        }
    }

    protected int read(long[] l, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                l[i] = this.readLong();
            }
            return length * 8;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 8);
        }
    }

    protected int read(short[] s, int start, int length) throws IOException {
        int i;
        try {
            for (i = start; i < start + length; ++i) {
                s[i] = this.readShort();
            }
            return length * 2;
        }
        catch (EOFException e) {
            return this.eofCheck(e, start, i, 2);
        }
    }

    protected boolean readBoolean() throws IOException {
        this.checkBuffer(1);
        return this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] == 1;
    }

    protected char readChar() throws IOException {
        this.checkBuffer(2);
        return (char)this.readUncheckedShort();
    }

    protected int readInt() throws IOException {
        this.checkBuffer(4);
        return this.readUncheckedInt();
    }

    protected long readLArray(Object o) throws IOException {
        return new PrimitiveArrayRecurse().primitiveArrayRecurse(o);
    }

    protected long readLong() throws IOException {
        this.checkBuffer(8);
        int i1 = this.readUncheckedInt();
        int i2 = this.readUncheckedInt();
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    protected double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    protected float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    protected void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(b, off, len) < len) {
            throw new EOFException();
        }
    }

    protected short readShort() throws IOException {
        this.checkBuffer(2);
        return (short)this.readUncheckedShort();
    }

    private int readUncheckedInt() {
        return this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] << 24 | (this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] & 0xFF) << 16 | (this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] & 0xFF) << 8 | this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] & 0xFF;
    }

    private int readUncheckedShort() {
        return this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] << 8 | this.sharedBuffer.buffer[this.sharedBuffer.bufferOffset++] & 0xFF;
    }

    private class PrimitiveArrayRecurse {
        private long primitiveArrayCount;

        private PrimitiveArrayRecurse() {
        }

        protected long primitiveArrayRecurse(Object o) throws IOException {
            block6: {
                PrimitiveType type;
                int length;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block5: {
                                                    if (o == null) {
                                                        return this.primitiveArrayCount;
                                                    }
                                                    if (!o.getClass().isArray()) {
                                                        throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + o.getClass().getName());
                                                    }
                                                    length = Array.getLength(o);
                                                    if (!o.getClass().getComponentType().isArray()) break block5;
                                                    for (int i = 0; i < length; ++i) {
                                                        this.primitiveArrayRecurse(Array.get(o, i));
                                                    }
                                                    break block6;
                                                }
                                                type = PrimitiveTypeHandler.valueOf(o.getClass().getComponentType());
                                                if (type != PrimitiveType.BOOLEAN) break block7;
                                                this.primitiveArrayCount += (long)BufferDecoder.this.read((boolean[])o, 0, length);
                                                break block6;
                                            }
                                            if (type != PrimitiveType.BYTE) break block8;
                                            int len = BufferDecoder.this.read((byte[])o, 0, length);
                                            this.primitiveArrayCount += (long)len;
                                            if (len < length) {
                                                throw new EOFException();
                                            }
                                            break block6;
                                        }
                                        if (type != PrimitiveType.CHAR) break block9;
                                        this.primitiveArrayCount += (long)BufferDecoder.this.read((char[])o, 0, length);
                                        break block6;
                                    }
                                    if (type != PrimitiveType.SHORT) break block10;
                                    this.primitiveArrayCount += (long)BufferDecoder.this.read((short[])o, 0, length);
                                    break block6;
                                }
                                if (type != PrimitiveType.INT) break block11;
                                this.primitiveArrayCount += (long)BufferDecoder.this.read((int[])o, 0, length);
                                break block6;
                            }
                            if (type != PrimitiveType.LONG) break block12;
                            this.primitiveArrayCount += (long)BufferDecoder.this.read((long[])o, 0, length);
                            break block6;
                        }
                        if (type != PrimitiveType.FLOAT) break block13;
                        this.primitiveArrayCount += (long)BufferDecoder.this.read((float[])o, 0, length);
                        break block6;
                    }
                    if (type != PrimitiveType.DOUBLE) break block14;
                    this.primitiveArrayCount += (long)BufferDecoder.this.read((double[])o, 0, length);
                    break block6;
                }
                if (type != PrimitiveType.STRING && type != PrimitiveType.UNKNOWN) break block6;
                for (int i = 0; i < length; ++i) {
                    this.primitiveArrayRecurse(Array.get(o, i));
                }
            }
            return this.primitiveArrayCount;
        }
    }
}

