
#include "addcards.hpp"

#include "extra_cards.hpp"
#include "database/DbConn.hpp" // FIXME
#include "fitsfiles.hpp"
#include "io.hpp"

#include <fstream>

using namespace std;


struct cards query_cards(const string db_uri, const string db_schema, unsigned int survey_id)
{
   LOG_trace(__func__);

   DbConn db(db_uri, db_schema);

   Survey surv = db.querySurveyAttributes(survey_id);

   struct cards values
   {
      surv.restFrequency,
         to_velocity_unit(surv.velocityFitsUnit)
   };

   return values;
}



void vlkb_addcards_by_surveyid(config conf, unsigned int survey_id, const std::string pathname, unsigned int hdunum)
{
   LOG_trace(__func__);

   const bool WITH_PASSWORD = true;

   string db_uri    = conf.getDbUri(WITH_PASSWORD);
   string db_schema = conf.getDbSchema();

   struct cards card_values = query_cards(db_uri, db_schema, survey_id);
   vector<struct fits_card> cards = convert_to_cards(card_values);

   fitsfiles::add_cards_if_missing(pathname, hdunum, cards); 
}


