
/* SODA 3.3.5 TIME
...numeric values interpreted as Modified Julian Date(s) in UTC.
As in DALI, open intervals use -Inf or +Inf as one limit.
*/

class Time
{
   enum System {MJD_UTC, NONE};

   System system;
   double mjdUtc[];

   public Time(String value)
   {
      mjdUtc = Parser.getDaliIntervalPositiveValues(value, "TIME");
   }

   public void setSystem(Time.System system) { this.system = system; }

   public String toString()
   {
      return "TIME " + mjdUtc[0] + " " + mjdUtc[1];
   }

}

