/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.json.bind.JsonbException;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractItem;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;

public abstract class AbstractContainerDeserializer<T>
extends AbstractItem<T>
implements JsonbDeserializer<T> {
    protected JsonbRiParser.LevelContext parserContext;

    protected AbstractContainerDeserializer(DeserializerBuilder builder) {
        super(builder);
    }

    public final T deserialize(JsonParser parser, DeserializationContext context, Type rtType) {
        Unmarshaller ctx = (Unmarshaller)context;
        ctx.setCurrent(this);
        this.deserializeInternal((JsonbParser)parser, ctx);
        ctx.setCurrent((CurrentItem<?>)this.getWrapper());
        return this.getInstance((Unmarshaller)context);
    }

    protected abstract T getInstance(Unmarshaller var1);

    protected void deserializeInternal(JsonbParser parser, Unmarshaller context) {
        this.parserContext = this.moveToFirst(parser);
        block6: while (parser.hasNext()) {
            JsonParser.Event event = parser.next();
            switch (event) {
                case START_OBJECT: 
                case START_ARRAY: 
                case VALUE_STRING: 
                case VALUE_NUMBER: 
                case VALUE_FALSE: 
                case VALUE_TRUE: {
                    this.deserializeNext(parser, context);
                    continue block6;
                }
                case KEY_NAME: {
                    continue block6;
                }
                case VALUE_NULL: {
                    this.appendResult(null);
                    continue block6;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    return;
                }
            }
            throw new JsonbException(Messages.getMessage(MessageKeys.NOT_VALUE_TYPE, event));
        }
    }

    protected abstract void deserializeNext(JsonParser var1, Unmarshaller var2);

    protected abstract JsonbRiParser.LevelContext moveToFirst(JsonbParser var1);

    protected DeserializerBuilder newUnmarshallerItemBuilder(JsonbContext ctx) {
        return ((DeserializerBuilder)new DeserializerBuilder(ctx).withWrapper(this)).withJsonValueType(this.parserContext.getLastEvent());
    }

    protected JsonbDeserializer<?> newCollectionOrMapItem(Type valueType, JsonbContext ctx) {
        Type actualValueType = ReflectionUtils.resolveType(this, valueType);
        ClassModel classModel = ctx.getMappingContext().getOrCreateClassModel(ReflectionUtils.getRawType(actualValueType));
        return ((DeserializerBuilder)((DeserializerBuilder)this.newUnmarshallerItemBuilder(ctx).withType(actualValueType)).withCustomization(classModel == null ? null : classModel.getCustomization())).build();
    }

    protected Object convertNullToOptionalEmpty(Type propertyType, Object value) {
        if (value != null) {
            return value;
        }
        if (!(propertyType instanceof Class)) {
            propertyType = ReflectionUtils.getRawType(ReflectionUtils.resolveType(this, propertyType));
        }
        if (propertyType == Optional.class) {
            return Optional.empty();
        }
        if (propertyType == OptionalInt.class) {
            return OptionalInt.empty();
        }
        if (propertyType == OptionalLong.class) {
            return OptionalLong.empty();
        }
        if (propertyType == OptionalDouble.class) {
            return OptionalDouble.empty();
        }
        return null;
    }

    public abstract void appendResult(Object var1);
}

