#ifndef M4VL_HPP
#define M4VL_HPP

#include <sys/param.h> // NAME_MAX PATH_MAX


struct merge_files {
    const char * mroot;      // dir where to create temporary working dir for merge
    const char * mresdir;    // dir where to place resulting merged file
    const char * prefix;     // merge filename prefix after "vlkb-merged_" supplied by client (optional)
};

//FIXME review pointers which should be const
// fitsfiles - full path and filename
int M4VL_mergefiles(struct merge_files * p, size_t nfiles, char * fitsfiles[], char * merged, size_t merged_len);

int M4VL_mergefiles_split(struct merge_files * p, size_t nfiles, char * fitsfiles[], char * merged, size_t merged_len);

#define TS_LEN (256)
#define MPATHLEN PATH_MAX
#define MFNAMELEN NAME_MAX
struct merge_config
{
	unsigned long dim;
	char ts[TS_LEN];
	char pidtidstr[NAME_MAX];
	
	char mroot[MPATHLEN];
        char mpath[MPATHLEN];
        char mpathin[MPATHLEN];
        char mpathproj[MPATHLEN];
        char cmnhdr[MPATHLEN + MFNAMELEN];
   char prefix[MPATHLEN]; // FIXME prefix was misused for dim: "2" "3" -> (2D 3D)
   char mresdir[MPATHLEN];
   char merged[MPATHLEN + MFNAMELEN];
};

void M4VL_merge_config_init(
                const char * jobid,    // IN some identifier to separate paralel merge requests
                const char * mroot,    // IN dir where merge will create temporary working dirs
                const char * mresdir,  // IN result merged file put to this dir
                unsigned long dim,     // IN dimensionalty of data (2D | 3D)
                struct merge_config * s); // OUT



int M4VL_mergefiles_common_header(
		struct merge_config * s, 	// IN OUT internal state of merge
		size_t nfiles, const char * fitsfiles[]);// IN pathnames to FITS-files to merge

int M4VL_mergefiles_reproject(
                struct merge_config * s, // IN OUT internal state of merge
                const char * fitsfile);  // IN  pathname of one FITS-files to re-project

int M4VL_mergefiles_add_reprojected(
                struct merge_config * s,                 // IN OUT internal state of merge
                char * argmpath, size_t argmpath_maxlen);  // OUT pathname of merged FTS-file (up to max name length)


#endif

