/*
 * Decompiled with CFR 0.152.
 */
package uws.service.error;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONWriter;
import uws.AcceptHeader;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.ErrorType;
import uws.job.UWSJob;
import uws.job.user.JobOwner;
import uws.service.error.ServiceErrorWriter;
import uws.service.log.UWSLog;

public class DefaultUWSErrorWriter
implements ServiceErrorWriter {
    protected final String[] managedFormats = new String[]{"application/json", "json", "text/json", "text/html", "html"};
    protected final UWSLog logger;

    public DefaultUWSErrorWriter(UWSLog logger) {
        if (logger == null) {
            throw new NullPointerException("Missing logger! Can not write a default error writer without.");
        }
        this.logger = logger;
    }

    @Override
    public boolean writeError(Throwable t, HttpServletResponse response, HttpServletRequest request, String reqID, JobOwner user, String action) {
        if (t == null || response == null) {
            return true;
        }
        boolean written = false;
        if (t instanceof UWSException) {
            UWSException ue = (UWSException)t;
            written = this.writeError(ue.getMessage(), ue.getUWSErrorType(), ue.getHttpErrorCode(), response, request, reqID, user, action);
        } else {
            this.logger.logUWS(UWSLog.LogLevel.FATAL, null, null, "[REQUEST N\u00b0" + reqID + "] " + t.getMessage(), t);
            written = this.writeError("INTERNAL SERVER ERROR! Sorry, this error is unexpected and no explanation can be provided for the moment. Details about this error have been reported in the service log files ; you should try again your request later or notify the administrator(s) by yourself (with the following 'Request ID').", ErrorType.FATAL, 500, response, request, reqID, user, action);
        }
        return written;
    }

    @Override
    public boolean writeError(String message, ErrorType type, int httpErrorCode, HttpServletResponse response, HttpServletRequest request, String reqID, JobOwner user, String action) {
        if (message == null || response == null) {
            return true;
        }
        try {
            this.formatError(message, type, httpErrorCode, reqID, action, user, response, request != null ? request.getHeader("Accept") : null);
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public void writeError(Throwable t, ErrorSummary error, UWSJob job, OutputStream output) throws IOException {
        UWSToolBox.writeErrorFile(t instanceof Exception ? (Exception)t : new UWSException(t), error, job, output);
    }

    @Override
    public String getErrorDetailsMIMEType() {
        return "text/plain";
    }

    protected final String chooseFormat(String acceptHeader) {
        if (acceptHeader != null && !acceptHeader.trim().isEmpty()) {
            AcceptHeader accept = new AcceptHeader(acceptHeader);
            List<String> lstMimeTypes = accept.getOrderedMimeTypes();
            for (String acceptedFormat : lstMimeTypes) {
                for (String f : this.managedFormats) {
                    if (!acceptedFormat.equalsIgnoreCase(f)) continue;
                    return f;
                }
            }
        }
        return null;
    }

    protected void formatError(String message, ErrorType type, int httpErrorCode, String reqID, String action, JobOwner user, HttpServletResponse response, String acceptHeader) throws IOException {
        String format = this.chooseFormat(acceptHeader);
        if (format != null && (format.equalsIgnoreCase("application/json") || format.equalsIgnoreCase("text/json") || format.equalsIgnoreCase("json"))) {
            this.formatJSONError(message, type, httpErrorCode, reqID, action, user, response);
        } else {
            this.formatHTMLError(message, type, httpErrorCode, reqID, action, user, response);
        }
    }

    protected void formatHTMLError(String message, ErrorType type, int httpErrorCode, String reqID, String action, JobOwner user, HttpServletResponse response) throws IOException {
        PrintWriter out;
        try {
            response.reset();
            response.setStatus(httpErrorCode);
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            out = response.getWriter();
        }
        catch (IllegalStateException ise) {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream())));
        }
        out.println("<html>\n\t<head>");
        out.println("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        out.println("\t\t<style type=\"text/css\">");
        out.println("\t\t\tbody { background-color: white; color: black; }");
        out.println("\t\t\th2 { font-weight: bold; font-variant: small-caps; text-decoration: underline; font-size: 1.5em; color: #4A4A4A; }");
        out.println("\t\t\tul, ol { margin-left: 2em; margin-top: 0.2em; text-align: justify; }");
        out.println("\t\t\tli { margin-bottom: 0.2em; margin-top: 0; }");
        out.println("\t\t\tp, p.listheader { text-align: justify; text-indent: 2%; margin-top: 0; }");
        out.println("\t\t\ttable { border-collapse: collapse; }");
        out.println("\t\t\ttable, th, td { border: 1px solid #FC8813; }");
        out.println("\t\t\tth { background-color: #F29842; color: white; font-size: 1.1em; }");
        out.println("\t\t\ttr.alt { background-color: #FFDAB6; }");
        out.println("\t\t</style>");
        out.println("\t\t<title>SERVICE ERROR</title>");
        out.println("\t</head>\n\t<body>");
        String errorColor = type == ErrorType.FATAL ? "red" : "orange";
        out.println("\t\t<h1 style=\"text-align: center; background-color:" + errorColor + "; color: white; font-weight: bold;\">SERVICE ERROR - " + httpErrorCode + "</h1>");
        out.println("\t\t<h2>Description</h2>");
        out.println("\t\t<ul>");
        out.println("\t\t\t<li><b>Type: </b>" + (Object)((Object)type) + "</li>");
        if (reqID != null) {
            out.println("\t\t\t<li><b>Request ID: </b>" + reqID + "</li>");
        }
        if (action != null) {
            out.println("\t\t\t<li><b>Action: </b>" + action + "</li>");
        }
        out.println("\t\t\t<li><b>Message:</b><p>" + message + "</p></li>");
        out.println("\t\t</ul>");
        out.println("\t</body>\n</html>");
        out.flush();
    }

    protected void formatJSONError(String message, ErrorType type, int httpErrorCode, String reqID, String action, JobOwner user, HttpServletResponse response) throws IOException {
        PrintWriter out;
        try {
            response.reset();
            response.setStatus(httpErrorCode);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            out = response.getWriter();
        }
        catch (IllegalStateException ise) {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream())));
        }
        try {
            JSONWriter json = new JSONWriter(out);
            json.object();
            json.key("errorcode").value(httpErrorCode);
            json.key("errortype").value(type.toString());
            if (reqID != null) {
                json.key("requestid").value(reqID);
            }
            if (action != null) {
                json.key("action").value(action);
            }
            json.key("message").value(message);
            json.endObject();
            out.flush();
        }
        catch (JSONException je) {
            this.logger.logUWS(UWSLog.LogLevel.ERROR, null, "FORMAT_ERROR", "Impossible to format/write an error in JSON!", je);
            throw new IOException("Error while formatting the error in JSON!", je);
        }
    }
}

