/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.utilities;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.header.Checksum;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.BufferedDataOutputStream;

public final class FitsCheckSum {
    private static final int CHECKSUM_STRING_SIZE = 16;
    private static final Logger LOG = Logger.getLogger(FitsCheckSum.class.getName());
    private static final int CHECKSUM_BLOCK_SIZE = 4;
    private static final int CHECKSUM_HALF_BLOCK_SIZE = 2;

    private FitsCheckSum() {
    }

    public static long checksum(byte[] data) {
        long hi = 0L;
        long lo = 0L;
        int len = 2 * (data.length / 4);
        int remain = data.length % 4;
        if (remain != 0) {
            throw new IllegalArgumentException("fits blocks always must be devidable by 4");
        }
        for (int i = 0; i < len; i += 2) {
            int offset = 2 * i;
            hi += (long)(data[offset++] << 8) & 0xFF00L | (long)data[offset++] & 0xFFL;
            lo += (long)(data[offset++] << 8) & 0xFF00L | (long)data[offset++] & 0xFFL;
        }
        long hicarry = hi >>> 16;
        long locarry = lo >>> 16;
        while (hicarry != 0L || locarry != 0L) {
            hi = (hi & 0xFFFFL) + locarry;
            lo = (lo & 0xFFFFL) + hicarry;
            hicarry = hi >>> 16;
            locarry = lo >>> 16;
        }
        return hi << 16 | lo;
    }

    public static String checksumEnc(long c, boolean compl) {
        byte[] asc = new byte[16];
        int[] exclude = new int[]{58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 95, 96};
        long[] mask = new long[]{0xFF000000L, 0xFF0000L, 65280L, 255L};
        int offset = 48;
        long value = compl ? c ^ 0xFFFFFFFFFFFFFFFFL : c;
        for (int i = 0; i < 4; ++i) {
            int byt = (int)((value & mask[i]) >>> 24 - 8 * i);
            int quotient = byt / 4 + 48;
            int remainder = byt % 4;
            int[] ch = new int[4];
            for (int j = 0; j < 4; ++j) {
                ch[j] = quotient;
            }
            ch[0] = ch[0] + remainder;
            boolean check = true;
            while (check) {
                check = false;
                for (int element : exclude) {
                    for (int j = 0; j < 4; j += 2) {
                        if (ch[j] != element && ch[j + 1] != element) continue;
                        int n = j;
                        ch[n] = ch[n] + 1;
                        int n2 = j + 1;
                        ch[n2] = ch[n2] - 1;
                        check = true;
                    }
                }
            }
            for (int j = 0; j < 4; ++j) {
                asc[4 * j + i] = (byte)ch[j];
            }
        }
        String resul = AsciiFuncs.asciiString(asc, 15, 1);
        return resul.concat(AsciiFuncs.asciiString(asc, 0, 15));
    }

    public static void setChecksum(BasicHDU<?> hdu) throws FitsException {
        Header hdr = hdu.getHeader();
        hdr.deleteKey(Checksum.CHECKSUM);
        hdr.addValue((IFitsHeader)Checksum.CHECKSUM, "0000000000000000");
        ByteArrayOutputStream hduByteImage = new ByteArrayOutputStream();
        BufferedDataOutputStream bdos = new BufferedDataOutputStream(hduByteImage);
        ((Data)hdu.getData()).write(bdos);
        try {
            bdos.flush();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "should not happen", e);
        }
        byte[] data = hduByteImage.toByteArray();
        FitsCheckSum.checksum(data);
        hdu.write(new BufferedDataOutputStream(hduByteImage));
        long csd = FitsCheckSum.checksum(data);
        hdu.getHeader().addValue((IFitsHeader)Checksum.DATASUM, Long.toString(csd));
        hduByteImage.reset();
        hdu.getHeader().write(bdos);
        try {
            bdos.flush();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "should not happen", e);
        }
        data = hduByteImage.toByteArray();
        long csh = FitsCheckSum.checksum(data);
        long cshdu = csh + csd;
        while ((cshdu & 0xFFFFFFFF00000000L) != 0L) {
            long cshduIntPart = cshdu & 0xFFFFFFFFL;
            cshdu = cshduIntPart + 1L;
        }
        hdr.addValue((IFitsHeader)Checksum.CHECKSUM, FitsCheckSum.checksumEnc(cshdu, true));
    }
}

