
### License   
*Copyright (C) 2024 Istituto Nazionale di Astrofisica   
SPDX-License-Identifier: GPL-3.0-or-later*


## vlkb-soda

is a web-application to access astronomical data stored in FITS-files.
It implements [IVOA SODA v1.0](https://ivoa.net/documents/SODA/20170517/index.html) and it supports security by OpenIDConnect/OAuth2.0.

When used with [vlkb-siav2](https://ict.inaf.it/gitlab/ViaLactea/vlkb-siav2) they provide complete data-discovery and access solution.

## Launching the service (docker, kubernetes)

The vlkb-soda service is available as a docker-image and may be launched as examplified in this [**compose.yaml**](docker/example-compose-soda.yaml). Mount the root of the FITS-file store to internal /srv/datasets directory. Also set the service port-number and ACCESS_CONTEXT_ROOT. To see that the instance is running, access the availability endpoint:

```bash
curl --get http://localhost:8004/vlkb/datasets/availability
```
Kubernetes manifests are available in [vlkb-k8s](https://ict.inaf.it/gitlab/ViaLactea/vlkb-k8s) project.

## End-points

- **availability** is a [VOSI](https://ivoa.net/documents/VOSI/20170524/REC-VOSI-1.1.html) end-point and returns information whether the service is active
- **capabilities** is a [VOSI](https://ivoa.net/documents/VOSI/20170524/REC-VOSI-1.1.html) end-point which describes service' functions and paramters
- **sync** synchronous end-point provides [SODA](https://ivoa.net/documents/SODA/20170517/index.html) service
- **async/uws** (optional) asynchronous [UWS](https://ivoa.net/documents/UWS/20161024/REC-UWS-1.1-20161024.html#ApplicationsOfUWS) endpoint which provides *mcutout*: a non-standard service which allows several cuts to be specified in one request by a [Job Description Language](JDL.md). All cuts are returned in one compressed file.


## Docker image

is available from the gitlab-repository of this project.

SODA-docker's internal mount point for the FITS-files storage is **/srv/datasets** (read-only); which is the only mandatory element. The rest of configuration is optional.

SODA-docker's internal mount point which temporarely holds cut files is **/srv/cutouts** (read-write) for **mcutout only**.

Configuration parameters, all optional:

| parameter | description  |
|---------|--------------|
| **ACCESS_CONTEXT_ROOT** | root of the end-points (default: 'soda') |
| **ENABLE_ASYNC_UWS** | set true to enable async endpoint (default: false) |

Context-root parameter uses 'tomcat syntax' in which the forward-slash path-separator is replaced with hash: vlkb#datasets -> vlkb/datasets

## Security (optional)

The data store may hold public and/or private collections.

The vlkb-soda supports OIDC/OAuth2.0 protocol and will validate access token in the request.
Non authenticated requests may be allowed by configuration, and will access only public data.

If request passes token validation, group-based authorization check is performed. A user may access the data
if at least on of the user's groups is allowed the access. Access rights for data collections are held in the authorization table.

Administer new users with [AUTH](https://ict.inaf.it/gitlab/ViaLactea/vlkb-authz) service. 

Configure security:

| parameter | description  |
|---------|--------------|
| **OIDC_RAP_URL** | root URL of an Open ID Connect comaptible identity service |
| **OIDC_GMS_URL** | root URL of Group Management Service |
| **OIDC_CLIENT** | client-id of a Relying party |
| **OIDC_SECRET** | secret of of the client |
| **AUTHZ_DB_URL** | DB where a table with authorization info ('groups' column) can be found |
| **AUTHZ_DB_USERNAME** | user in the DB with authorization table |
| **AUTHZ_DB_PASSWORD** | password for the DB-user |



