/* vim:set ft=c ts=2 sw=2 sts=2 et cindent: */
#ifndef RPC_AMQP_UTILS_HPP
#define RPC_AMQP_UTILS_HPP

#include <amqp.h>

void die(const char *fmt, ...);
extern void die_on_error(int x, char const *context);
extern void die_on_amqp_error(amqp_rpc_reply_t x, char const *context);

extern void amqp_dump(void const *buffer, size_t len);

extern uint64_t now_microseconds(void);
extern void microsleep(int usec);


void throw_ex_on_amqp_error(amqp_connection_state_t conn, amqp_rpc_reply_t x, char const *context);


#endif
