/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.Entry;
import org.cache2k.core.Hash2;
import org.cache2k.core.HeapCache;
import org.cache2k.core.concurrency.Job;

public class ConcurrentEntryIterator<K, V>
implements Iterator<Entry<K, V>> {
    private HeapCache<K, V> cache;
    private Entry<K, V> lastEntry = null;
    private Entry<K, V> nextEntry = null;
    private long clearCount;
    private Hash2<K, V> hash;
    private Entry<K, V>[] hashArray;
    private HashMap<K, K> seen = new HashMap();

    public ConcurrentEntryIterator(HeapCache<K, V> _cache) {
        this.cache = _cache;
        this.hash = this.cache.hash;
        this.switchAndCheckAbort();
    }

    @Override
    public boolean hasNext() {
        this.nextEntry = this.nextEntry();
        return this.nextEntry != null;
    }

    @Override
    public Entry<K, V> next() {
        if (this.nextEntry != null) {
            Entry<K, V> e = this.nextEntry;
            this.nextEntry = null;
            return e;
        }
        Entry<K, V> e = this.nextEntry();
        if (e == null) {
            throw new NoSuchElementException("not available");
        }
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasBeenIterated(K key, int _hashCode) {
        return this.seen.containsKey(key);
    }

    public void markIterated(K key, int _hashCode) {
        this.seen.put(key, key);
    }

    private Entry<K, V> nextEntry() {
        Entry<K, V> e;
        if (this.hashArray == null) {
            return null;
        }
        if (this.needsAbort()) {
            if (this.hash != null && this.cache.isClosed()) {
                this.clearOutReferences();
                throw new CacheClosedException(this.cache);
            }
            this.clearOutReferences();
            return null;
        }
        int idx = 0;
        if (this.lastEntry != null) {
            e = this.lastEntry.another;
            if (e != null && (e = this.checkIteratedOrNext(e)) != null) {
                this.lastEntry = e;
                return e;
            }
            idx = (this.cache.extractModifiedHash(this.lastEntry) & this.hashArray.length - 1) + 1;
        }
        while (true) {
            if (idx >= this.hashArray.length) {
                if (this.switchAndCheckAbort()) {
                    return null;
                }
                idx = 0;
            }
            if ((e = this.hashArray[idx]) != null && (e = this.checkIteratedOrNext(e)) != null) {
                this.lastEntry = e;
                return e;
            }
            ++idx;
        }
    }

    private boolean needsAbort() {
        return this.clearCount != (long)this.hash.getClearOrCloseCount();
    }

    private Entry<K, V> checkIteratedOrNext(Entry<K, V> e) {
        do {
            K _key;
            boolean _notYetIterated;
            boolean bl = _notYetIterated = !this.seen.containsKey(_key = this.cache.extractKeyObj(e));
            if (!_notYetIterated) continue;
            this.markIterated(_key, this.cache.extractModifiedHash(e));
            return e;
        } while ((e = e.another) != null);
        return null;
    }

    private boolean switchAndCheckAbort() {
        if (Thread.holdsLock(this.cache.lock)) {
            return this.switchCheckAndAbortLocked();
        }
        return this.cache.executeWithGlobalLock(new Job<Boolean>(){

            @Override
            public Boolean call() {
                return ConcurrentEntryIterator.this.switchCheckAndAbortLocked();
            }
        });
    }

    private Boolean switchCheckAndAbortLocked() {
        boolean _cacheClosed;
        if (!this.hasExpansionOccurred()) {
            this.clearOutReferences();
            return true;
        }
        this.hashArray = this.hash.getEntries();
        this.clearCount = this.hash.getClearOrCloseCount();
        boolean bl = _cacheClosed = this.hashArray == null;
        if (_cacheClosed) {
            this.clearOutReferences();
            throw new CacheClosedException(this.cache);
        }
        return false;
    }

    private void clearOutReferences() {
        this.hash = null;
        this.hashArray = null;
        this.seen = null;
    }

    private boolean hasExpansionOccurred() {
        return this.hashArray != this.hash.getEntries();
    }
}

