/*
 * Decompiled with CFR 0.152.
 */
package uws.job.manager;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ExecutionPhase;
import uws.job.UWSJob;
import uws.job.manager.ExecutionManager;
import uws.service.log.UWSLog;

public class DefaultExecutionManager
implements ExecutionManager {
    protected Map<String, UWSJob> runningJobs = new LinkedHashMap<String, UWSJob>(10);
    protected final UWSLog logger;

    public DefaultExecutionManager() {
        this(null);
    }

    public DefaultExecutionManager(UWSLog logger) {
        this.logger = logger == null ? UWSToolBox.getDefaultLogger() : logger;
    }

    @Override
    public final Iterator<UWSJob> getRunningJobs() {
        return this.runningJobs.values().iterator();
    }

    @Override
    public final int getNbRunningJobs() {
        return this.runningJobs.size();
    }

    @Override
    public final Iterator<UWSJob> getQueuedJobs() {
        return new Iterator<UWSJob>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public UWSJob next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public final int getNbQueuedJobs() {
        return 0;
    }

    @Override
    public final void refresh() {
    }

    @Override
    public synchronized ExecutionPhase execute(UWSJob jobToExecute) {
        if (jobToExecute == null) {
            return null;
        }
        if (jobToExecute.isRunning()) {
            this.runningJobs.put(jobToExecute.getJobId(), jobToExecute);
        } else if (jobToExecute.isFinished()) {
            this.runningJobs.remove(jobToExecute);
            this.logger.logJob(UWSLog.LogLevel.WARNING, jobToExecute, "START", "Job \"" + jobToExecute.getJobId() + "\" already finished!", null);
        } else {
            try {
                jobToExecute.start(false);
                this.runningJobs.put(jobToExecute.getJobId(), jobToExecute);
            }
            catch (UWSException ue) {
                this.logger.logJob(UWSLog.LogLevel.ERROR, jobToExecute, "START", "Can not start the job \"" + jobToExecute.getJobId() + "\"! This job is not any more part of its execution manager.", ue);
            }
        }
        return jobToExecute.getPhase();
    }

    @Override
    public synchronized void remove(UWSJob jobToRemove) {
        if (jobToRemove != null) {
            this.runningJobs.remove(jobToRemove.getJobId());
        }
    }

    @Override
    public synchronized void stopAll() {
        for (UWSJob rj : this.runningJobs.values()) {
            try {
                rj.abort();
                rj.setPhase(ExecutionPhase.PENDING, true);
            }
            catch (UWSException ue) {
                if (this.logger == null) continue;
                this.logger.logJob(UWSLog.LogLevel.WARNING, rj, "ABORT", "Can not stop the job nicely. The thread may continue to run until its end.", ue);
            }
        }
        this.runningJobs.clear();
    }
}

