/*
 * Decompiled with CFR 0.152.
 */
package uws.job.serializer;

import java.io.Serializable;
import uws.ISO8601Format;
import uws.UWSException;
import uws.job.ErrorSummary;
import uws.job.JobList;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.serializer.filter.JobListRefiner;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.UWSUrl;

public abstract class UWSSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE_XML = "text/xml";
    public static final String MIME_TYPE_JSON = "application/json";
    public static final String MIME_TYPE_TEXT = "text/plain";
    public static final String MIME_TYPE_HTML = "text/html";

    public String getJob(UWSJob job, String[] attributes, boolean root) throws Exception {
        if (attributes == null || attributes.length <= 0) {
            return this.getJob(job, root);
        }
        String firstAttribute = attributes[0];
        if (firstAttribute.equalsIgnoreCase("jobId")) {
            return job.getJobId();
        }
        if (firstAttribute.equalsIgnoreCase("runId")) {
            return job.getRunId() == null ? "" : job.getRunId();
        }
        if (firstAttribute.equalsIgnoreCase("owner")) {
            return job.getOwner() == null ? "" : job.getOwner().getPseudo();
        }
        if (firstAttribute.equalsIgnoreCase("phase")) {
            return job.getPhase().toString();
        }
        if (firstAttribute.equalsIgnoreCase("quote")) {
            return job.getQuote() + "";
        }
        if (firstAttribute.equalsIgnoreCase("creationTime")) {
            return ISO8601Format.format(job.getCreationTime());
        }
        if (firstAttribute.equalsIgnoreCase("startTime")) {
            return job.getStartTime() == null ? "" : ISO8601Format.format(job.getStartTime());
        }
        if (firstAttribute.equalsIgnoreCase("endTime")) {
            return job.getEndTime() == null ? "" : ISO8601Format.format(job.getEndTime());
        }
        if (firstAttribute.equalsIgnoreCase("executionDuration")) {
            return job.getExecutionDuration() + "";
        }
        if (firstAttribute.equalsIgnoreCase("destruction")) {
            return job.getDestructionTime() == null ? "" : ISO8601Format.format(job.getDestructionTime());
        }
        if (firstAttribute.equalsIgnoreCase("parameters")) {
            if (attributes.length <= 1) {
                return this.getAdditionalParameters(job, root);
            }
            String secondAttribute = attributes[1];
            Object value = job.getAdditionalParameterValue(secondAttribute);
            if (value != null) {
                if (value.getClass().isArray()) {
                    Object[] items = (Object[])value;
                    StringBuffer arrayAsString = new StringBuffer();
                    for (Object item : items) {
                        if (arrayAsString.length() > 0) {
                            arrayAsString.append(' ').append(';').append(' ');
                        }
                        arrayAsString.append(item.toString());
                    }
                    return arrayAsString.toString();
                }
                return value.toString();
            }
            throw new UWSException(404, "No parameter named \"" + secondAttribute + "\" in the job \"" + job.getJobId() + "\"!");
        }
        if (firstAttribute.equalsIgnoreCase("results")) {
            if (attributes.length <= 1) {
                return this.getResults(job, root);
            }
            String secondAttribute = attributes[1];
            Result r = job.getResult(secondAttribute);
            if (r != null) {
                return this.getResult(r, root);
            }
            throw new UWSException(404, "No result named \"" + secondAttribute + "\" in the job \"" + job.getJobId() + "\"!");
        }
        if (firstAttribute.equalsIgnoreCase("error")) {
            if (job.getErrorSummary() != null && job.getErrorSummary().hasDetail()) {
                throw new UWSException(303, job.getErrorSummary().getDetails().toString());
            }
            return this.getErrorSummary(job.getErrorSummary(), root);
        }
        throw new UWSException(404, "No job attribute named \"" + firstAttribute + "\" in the job \"" + job.getJobId() + "\"!");
    }

    public String toString() {
        return this.getMimeType();
    }

    public abstract String getMimeType();

    public String getUWS(UWS uws) throws Exception {
        return this.getUWS(uws, null);
    }

    public abstract String getUWS(UWS var1, JobOwner var2) throws Exception;

    public String getJobList(JobList jobsList, boolean root) throws Exception {
        return this.getJobList(jobsList, null, root);
    }

    public String getJobList(JobList jobsList, JobOwner owner, boolean root) throws Exception {
        return this.getJobList(jobsList, null, null, root);
    }

    public abstract String getJobList(JobList var1, JobOwner var2, JobListRefiner var3, boolean var4) throws Exception;

    public abstract String getJob(UWSJob var1, boolean var2) throws Exception;

    public abstract String getJobRef(UWSJob var1, UWSUrl var2) throws Exception;

    public abstract String getJobID(UWSJob var1, boolean var2) throws Exception;

    public abstract String getRunID(UWSJob var1, boolean var2) throws Exception;

    public abstract String getOwnerID(UWSJob var1, boolean var2) throws Exception;

    public abstract String getPhase(UWSJob var1, boolean var2) throws Exception;

    public abstract String getQuote(UWSJob var1, boolean var2) throws Exception;

    public abstract String getCreationTime(UWSJob var1, boolean var2) throws Exception;

    public abstract String getStartTime(UWSJob var1, boolean var2) throws Exception;

    public abstract String getEndTime(UWSJob var1, boolean var2) throws Exception;

    public abstract String getExecutionDuration(UWSJob var1, boolean var2) throws Exception;

    public abstract String getDestructionTime(UWSJob var1, boolean var2) throws Exception;

    public abstract String getErrorSummary(ErrorSummary var1, boolean var2) throws Exception;

    public abstract String getResults(UWSJob var1, boolean var2) throws Exception;

    public abstract String getResult(Result var1, boolean var2) throws Exception;

    public abstract String getAdditionalParameters(UWSJob var1, boolean var2) throws Exception;

    public abstract String getAdditionalParameter(String var1, Object var2, boolean var3) throws Exception;
}

