
#ifndef CONFIG_HPP
#define CONFIG_HPP

#include <string>
#include <map>


class config
{
   public:

      void read_config(const std::string & settings_path);

      std::string getFitsDir() const       {return m_settings.at(fits_dir);}

      std::string getDbUri(bool with_password = false) const {return m_settings.at(pg_uri);}
      std::string getDbSchema() const   {return m_settings.at(pg_schema);}

      std::string getObsCorePublisher() const {return m_settings.at(obscore_publisher);}
      std::string getObscoreAccessUrl() const {return m_settings.at(obscore_access_url);}
      std::string getObsCoreAccessFormat() const {return m_settings.at(obscore_access_format);}

      std::string getLogDir() const      {return m_settings.at(log_dir);}
      std::string getLogFileName() const {return m_settings.at(log_filename);}


   private:
      std::string value(std::string key) {return m_settings.at(key);}

      const std::string fits_dir{"fits_path_surveys"};

      const std::string pg_uri{"pg_uri"};
      const std::string pg_schema{"pg_schema"};

      const std::string obscore_publisher{"obscore_publisher"};
      const std::string obscore_access_url{"obscore_access_url"};
      const std::string obscore_access_format{"obscore_access_format"};

      const std::string log_dir{"log_dir"};
      const std::string log_filename{"log_filename"};

      //-------------------------------------------------
      // defaults
      //-------------------------------------------------

      const std::string empty_string;

      std::map<const std::string, std::string> m_settings 
      {
         {fits_dir, "/srv/surveys"},

            {pg_uri,    empty_string},
            {pg_schema, empty_string},

            {obscore_publisher,     empty_string},
            {obscore_access_url,    empty_string},
            {obscore_access_format, "application/fits"},

            {log_dir,      "/tmp"},
            {log_filename, "vlkb-obscore.log"},

      };
};


#endif

