/*
 * Decompiled with CFR 0.152.
 */
package uws.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import uws.UWSException;

public final class UWSConfiguration {
    public static final String UWS_CONF_PARAMETER = "uwsconf";
    public static final String DEFAULT_UWS_CONF_FILE = "uws.properties";
    public static final String KEY_HOME_PAGE = "home_page";
    public static final String KEY_HOME_PAGE_MIME_TYPE = "home_page_mime_type";
    public static final String KEY_SERVICE_NAME = "service_name";
    public static final String KEY_SERVICE_DESCRIPTION = "service_description";
    public static final String KEY_JOB_LISTS = "joblists";
    public static final String REGEXP_JOB_LIST_NAME = "[^\\.=\\s]+";
    public static final String KEY_JOB_THREAD = "job_thread";
    public static final String REGEXP_JOB_THREAD = "[^\\.=\\s]+\\.job_thread";
    public static final String KEY_PARAMETERS = "job_parameters";
    public static final String REGEXP_PARAMETERS = "[^\\.=\\s]+\\.job_parameters";
    public static final String KEY_DEFAULT_EXECUTION_DURATION = "default_execution_duration";
    public static final String REGEXP_DEFAULT_EXEC_DURATION = "[^\\.=\\s]+\\.default_execution_duration";
    public static final String KEY_MAX_EXECUTION_DURATION = "max_execution_duration";
    public static final String REGEXP_MAX_EXEC_DURATION = "[^\\.=\\s]+\\.max_execution_duration";
    public static final int DEFAULT_EXECUTION_DURATION = 0;
    public static final String KEY_MAX_RUNNING_JOBS = "max_running_jobs";
    public static final String REGEXP_MAX_RUNNING_JOBS = "[^\\.=\\s]+\\.max_running_jobs";
    public static final String KEY_EXECUTION_MANAGER = "execution_manager";
    public static final String REGEXP_EXECUTION_MANAGER = "[^\\.=\\s]+\\.execution_manager";
    public static final String KEY_DEFAULT_DESTRUCTION_INTERVAL = "default_destruction_interval";
    public static final String REGEXP_DEFAULT_DESTRUCTION_INTERVAL = "[^\\.=\\s]+\\.default_destruction_interval";
    public static final String KEY_MAX_DESTRUCTION_INTERVAL = "max_destruction_interval";
    public static final String KEY_REGEXP_MAX_DESTRUCTION_INTERVAL = "[^\\.=\\s]+\\.max_destruction_interval";
    public static final String KEY_DESTRUCTION_MANAGER = "destruction_manager";
    public static final String REGEXP_DESTRUCTION_MANAGER = "[^\\.=\\s]+\\.destruction_manager";
    public static final String KEY_FILE_MANAGER = "file_manager";
    public static final String VALUE_LOCAL = "local";
    public static final String DEFAULT_FILE_MANAGER = "local";
    public static final String KEY_FILE_ROOT_PATH = "file_root_path";
    public static final String KEY_DIRECTORY_PER_USER = "directory_per_user";
    public static final boolean DEFAULT_DIRECTORY_PER_USER = false;
    public static final String KEY_GROUP_USER_DIRECTORIES = "group_user_directories";
    public static final boolean DEFAULT_GROUP_USER_DIRECTORIES = false;
    public static final String KEY_LOGGER = "logger";
    public static final String DEFAULT_LOGGER = "default";
    public static final String KEY_MIN_LOG_LEVEL = "min_log_level";
    public static final String KEY_LOG_ROTATION = "log_rotation";
    public static final String SLF4J_LOGGER = "slf4j";
    public static final String KEY_BACKUP_FREQUENCY = "backup_frequency";
    public static final String VALUE_NEVER = "never";
    public static final String VALUE_USER_ACTION = "user_action";
    public static final long DEFAULT_BACKUP_FREQUENCY = -1L;
    public static final String KEY_BACKUP_BY_USER = "backup_by_user";
    public static final boolean DEFAULT_BACKUP_BY_USER = false;
    public static final String KEY_USER_IDENTIFIER = "user_identifier";
    public static final String KEY_REQUEST_PARSER = "request_parser";
    public static final String KEY_ADD_SERIALIZERS = "additional_serializers";
    public static final String KEY_XSLT_STYLESHEET = "xslt_stylesheet";
    public static final String KEY_ERROR_WRITER = "error_writer";
    public static final String KEY_ADD_UWS_ACTIONS = "additional_actions";
    public static final String KEY_UWS_FACTORY = "uws_factory";

    private UWSConfiguration() {
    }

    public static final String getProperty(Properties prop, String key) {
        if (prop == null) {
            return null;
        }
        String value = prop.getProperty(key);
        if (value != null) {
            return (value = value.trim()).length() == 0 ? null : value;
        }
        return value;
    }

    public static final String extractJobListName(String compoundPropertyName) {
        if (compoundPropertyName == null || !compoundPropertyName.matches("[^\\.=\\s]+\\..+")) {
            return null;
        }
        return compoundPropertyName.substring(0, compoundPropertyName.indexOf(46));
    }

    public static final boolean isClassName(String value) {
        return value != null && value.length() > 2 && value.charAt(0) == '{' && value.charAt(value.length() - 1) == '}';
    }

    public static final <C> Class<? extends C> fetchClass(String value, String propertyName, Class<C> expectedType) throws UWSException {
        if (!UWSConfiguration.isClassName(value)) {
            return null;
        }
        String classPath = value.substring(1, value.length() - 1).trim();
        if (classPath.isEmpty()) {
            return null;
        }
        try {
            Class<?> classObject = Class.forName(classPath);
            if (!expectedType.isAssignableFrom(classObject)) {
                throw new UWSException("The class specified by the property \"" + propertyName + "\" (" + value + ") is not implementing " + expectedType.getName() + ".");
            }
            return classObject;
        }
        catch (ClassNotFoundException cnfe) {
            throw new UWSException("The class specified by the property \"" + propertyName + "\" (" + value + ") can not be found.");
        }
        catch (ClassCastException cce) {
            throw new UWSException("The class specified by the property \"" + propertyName + "\" (" + value + ") is not implementing " + expectedType.getName() + ".");
        }
    }

    public static final <C> boolean hasConstructor(String propValue, String propName, Class<C> expectedType, Class<?>[] pTypes) throws UWSException {
        if (!UWSConfiguration.isClassName(propValue)) {
            throw new UWSException("Class name expected for the property \"" + propName + "\" instead of: \"" + propValue + "\"! The specified class must extend/implement " + expectedType.getName() + ".");
        }
        Class<C> classObj = UWSConfiguration.fetchClass(propValue, propName, expectedType);
        try {
            classObj.getConstructor(pTypes == null ? new Class[]{} : pTypes);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final <C> Constructor<? extends C> fetchConstructor(String propValue, String propName, Class<C> expectedType, Class<?>[] pTypes) throws UWSException {
        if (!UWSConfiguration.isClassName(propValue)) {
            throw new UWSException("Class name expected for the property \"" + propName + "\" instead of: \"" + propValue + "\"! The specified class must extend/implement " + expectedType.getName() + ".");
        }
        Class<C> classObj = UWSConfiguration.fetchClass(propValue, propName, expectedType);
        try {
            return classObj.getConstructor(pTypes == null ? new Class[]{} : pTypes);
        }
        catch (NoSuchMethodException e) {
            StringBuffer pTypesStr = new StringBuffer();
            if (pTypes != null) {
                for (int i = 0; i < pTypes.length; ++i) {
                    if (pTypesStr.length() > 0) {
                        pTypesStr.append(", ");
                    }
                    if (pTypes[i] == null) {
                        pTypesStr.append("NULL");
                    }
                    pTypesStr.append(pTypes[i].getName());
                }
            }
            throw new UWSException("Missing constructor " + classObj.getName() + "(" + pTypesStr.toString() + ")! See the value \"" + propValue + "\" of the property \"" + propName + "\".");
        }
        catch (SecurityException se) {
            throw new UWSException(500, (Throwable)se, "Security error when trying to fetch the constructor with a single parameter of type " + expectedType.getName() + " of the class \"" + propValue + "\" specified by the property \"" + propName + "\"!");
        }
    }

    public static final <C> C newInstance(String propValue, String propName, Class<C> expectedType) throws UWSException {
        return UWSConfiguration.newInstance(propValue, propName, expectedType, null, null);
    }

    public static final <C> C newInstance(String propValue, String propName, Class<C> expectedType, Class<?>[] pTypes, Object[] parameters) throws UWSException {
        if (!UWSConfiguration.isClassName(propValue)) {
            throw new UWSException("Class name expected for the property \"" + propName + "\" instead of: \"" + propValue + "\"! The specified class must extend/implement " + expectedType.getName() + ".");
        }
        Class<C> classObj = null;
        try {
            classObj = UWSConfiguration.fetchClass(propValue, propName, expectedType);
            Constructor<C> constructor = classObj.getConstructor(pTypes == null ? new Class[]{} : pTypes);
            return constructor.newInstance(parameters == null ? new Object[]{} : parameters);
        }
        catch (NoSuchMethodException e) {
            StringBuffer pTypesStr = new StringBuffer();
            if (pTypes != null) {
                for (int i = 0; i < pTypes.length; ++i) {
                    if (pTypesStr.length() > 0) {
                        pTypesStr.append(", ");
                    }
                    if (pTypes[i] == null) {
                        pTypesStr.append("NULL");
                    }
                    pTypesStr.append(pTypes[i].getName());
                }
            }
            throw new UWSException("Missing constructor " + classObj.getName() + "(" + pTypesStr.toString() + ")! See the value \"" + propValue + "\" of the property \"" + propName + "\".");
        }
        catch (InstantiationException ie) {
            throw new UWSException("Impossible to create an instance of an abstract class: \"" + classObj.getName() + "\"! See the value \"" + propValue + "\" of the property \"" + propName + "\".");
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null) {
                if (ite.getCause() instanceof UWSException) {
                    throw (UWSException)ite.getCause();
                }
                throw new UWSException(ite.getCause());
            }
            throw new UWSException(ite);
        }
        catch (UWSException te) {
            throw te;
        }
        catch (Exception ex) {
            throw new UWSException(404, (Throwable)ex, "Impossible to create an instance of " + expectedType.getName() + " as specified in the property \"" + propName + "\": \"" + propValue + "\"!");
        }
    }

    public static final long parseLimit(String value, String propertyName) throws UWSException {
        if (value != null) {
            value = value.replaceAll("\\s", "");
        }
        if (value == null || value.length() == 0) {
            return -1L;
        }
        long numValue = -1L;
        StringBuffer buf = new StringBuffer();
        for (int i = value.length() - 1; i >= 0; --i) {
            if (value.charAt(i) >= '0' && value.charAt(i) <= '9') {
                try {
                    numValue = Integer.parseInt(value.substring(0, i + 1));
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new UWSException("Integer expected for the property " + propertyName + " for the substring \"" + value.substring(0, i + 1) + "\" of the whole value: \"" + value + "\"!");
                }
            }
            buf.append(value.charAt(i));
        }
        if (buf.length() != 0) {
            if (buf.length() > 2) {
                throw new UWSException("Unknown limit unit (" + buf.reverse().toString() + ") for the property " + propertyName + ": \"" + value + "\"!");
            }
            if (buf.charAt(0) != 'B') {
                throw new UWSException("Unknown limit unit (" + buf.reverse().toString() + ") for the property " + propertyName + ": \"" + value + "\"!");
            }
            if (buf.length() > 1) {
                switch (buf.charAt(1)) {
                    case 'G': {
                        numValue *= 1000L;
                    }
                    case 'M': {
                        numValue *= 1000L;
                    }
                    case 'k': {
                        numValue *= 1000L;
                        break;
                    }
                    default: {
                        throw new UWSException("Unknown limit unit (" + buf.reverse().toString() + ") for the property " + propertyName + ": \"" + value + "\"!");
                    }
                }
            }
        }
        return numValue < 0L ? -1L : numValue;
    }
}

