
#ifndef FITSFILES_HPP
#define FITSFILES_HPP

#include "cutout.hpp" // struct fits_card

#include <set>
#include <map>
#include <vector>
#include <string>

namespace fitsfiles
{
   std::string cfitsio_errmsg(const char * filename, int line_num, int status);

   // for db-ingestion

   std::uintmax_t fileSize(std::string pathname);
   std::vector<std::string> globVector(const std::string& pattern);
 
   struct keys_by_type
   {
      std::set<std::string> strKeys;
      std::set<std::string> uintKeys;
      std::set<std::string> doubleKeys;
   };

   struct key_values_by_type
   {
      std::map<std::string, std::string>   strValues;
      std::map<std::string, unsigned long> uintValues;
      std::map<std::string, double>        doubleValues;
   };

   struct Hdu 
   {
      unsigned int m_hdunum;
      std::string  m_header;
      key_values_by_type key_values;
   };

   std::vector<Hdu> fname2hdrstr(std::string filename, unsigned int maxHduPos, const keys_by_type *keys = nullptr);


   // for services

   std::string read_header(std::string pathname, unsigned int hdunum);
   void fits_hdu_cut(const std::string infile, const unsigned int hdunum,
         const std::string outfile);
   std::string append_card_if_not_in_header(std::string header, const std::vector<fits_card> additional_cards);

   // for vlkb cmds

   std::string read_card(const std::string pathname, unsigned int hdunum, const std::string keyname);
   void        add_cards_if_missing(const std::string pathname, unsigned int hdunum, const std::vector<struct fits_card> cards);
   int         mod_value(std::string filename, std::string token, std::string keyvalue);

   std::map<std::string, std::string> read_header_wcs_coord_type(const std::string pathname, unsigned int hdunum, char altwcs = ' ');

   double calc_nullvals(std::string pathname, unsigned int hdunum,
         unsigned long long & null_cnt, unsigned long long & total_cnt);

};

#endif

