#ifndef PARSE_SURVEYS_CSV_HPP
#define PARSE_SURVEYS_CSV_HPP

#include <string>
#include <vector>

enum class dataproduct {IMAGE, CUBE};
std::string to_string(dataproduct d);
dataproduct to_dataproduct(std::string raw_string);

enum class authorization_policy {PRIVATE, PUBLIC};
std::string to_string(authorization_policy p);
authorization_policy to_authorization_policy(std::string raw_string);

enum class velocity_unit {MPS, KMPS, KPC, NONE};
std::string to_string(velocity_unit);
velocity_unit to_velocity_unit(std::string raw_string);

enum class calibration {LEVEL0, LEVEL1, LEVEL2, LEVEL3, LEVEL4};
std::string to_string(calibration calib_level);
unsigned int to_uint(calibration calib_level);
calibration to_calibration(std::string raw_string);


struct survey
{
   unsigned int survey_id;
   std::string name;
   std::string species;
   std::string transition;
   unsigned long long rest_frequency_Hz;
//   std::string restf_fits_unit;    // NOT used
   velocity_unit velocity_fits_unit;
   std::string storage_path;
   std::string file_filter;
   std::string description;   // convert to UTF-8
   dataproduct dataproduct_type;
   calibration calib_level;
   std::string o_ucd;
   std::string fitskey_facility_name;   // length < 8
   std::string fitskey_instrument_name; // length < 8
   authorization_policy auth_policy;
};

std::ostream& operator<<( std::ostream &out, struct survey const& p);

std::vector<survey> parse_surveys(std::string filename, bool skip_first_row);

#endif
