/*
 * Decompiled with CFR 0.152.
 */
package uws.job.manager;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ExecutionPhase;
import uws.job.UWSJob;
import uws.job.manager.ExecutionManager;
import uws.service.log.UWSLog;

public abstract class AbstractQueuedExecutionManager
implements ExecutionManager {
    protected Map<String, UWSJob> runningJobs = new LinkedHashMap<String, UWSJob>();
    protected Vector<UWSJob> queuedJobs = new Vector(0, 10);
    protected final UWSLog logger;

    protected AbstractQueuedExecutionManager(UWSLog logger) {
        this.logger = logger == null ? UWSToolBox.getDefaultLogger() : logger;
    }

    @Override
    public final Iterator<UWSJob> getRunningJobs() {
        return this.runningJobs.values().iterator();
    }

    @Override
    public final int getNbRunningJobs() {
        return this.runningJobs.size();
    }

    @Override
    public final Iterator<UWSJob> getQueuedJobs() {
        return this.queuedJobs.iterator();
    }

    @Override
    public final int getNbQueuedJobs() {
        return this.queuedJobs.size();
    }

    public boolean hasQueue() {
        return !this.queuedJobs.isEmpty();
    }

    public abstract boolean isReadyForExecution(UWSJob var1);

    @Override
    public final synchronized void refresh() {
        if (!this.hasQueue()) {
            return;
        }
        while (!this.queuedJobs.isEmpty() && this.isReadyForExecution(this.queuedJobs.firstElement())) {
            UWSJob jobToStart = this.queuedJobs.remove(0);
            try {
                this.startJob(jobToStart);
            }
            catch (UWSException ue) {
                this.logger.logJob(UWSLog.LogLevel.ERROR, jobToStart, "START", "Can not start the job \"" + jobToStart.getJobId() + "\"! This job is not any more part of its execution manager.", ue);
            }
        }
    }

    protected void startJob(UWSJob jobToStartNow) throws UWSException {
        if (jobToStartNow != null) {
            jobToStartNow.start(false);
            this.queuedJobs.remove(jobToStartNow);
            this.runningJobs.put(jobToStartNow.getJobId(), jobToStartNow);
        }
    }

    @Override
    public final synchronized ExecutionPhase execute(UWSJob jobToExecute) {
        if (jobToExecute == null) {
            return null;
        }
        this.refresh();
        if (jobToExecute.isRunning()) {
            this.runningJobs.put(jobToExecute.getJobId(), jobToExecute);
        } else if (jobToExecute.isFinished()) {
            this.runningJobs.remove(jobToExecute);
            this.queuedJobs.remove(jobToExecute);
        } else {
            try {
                if (jobToExecute.getPhase() != ExecutionPhase.QUEUED) {
                    jobToExecute.setPhase(ExecutionPhase.QUEUED);
                }
                if (!this.queuedJobs.contains(jobToExecute)) {
                    this.queuedJobs.add(jobToExecute);
                    this.refresh();
                }
            }
            catch (UWSException ue) {
                this.logger.logJob(UWSLog.LogLevel.ERROR, jobToExecute, "QUEUE", "Can not set the job \"" + jobToExecute.getJobId() + "\" in the QUEUED phase!", ue);
                try {
                    jobToExecute.setPhase(ExecutionPhase.HELD);
                }
                catch (UWSException uWSException) {
                    // empty catch block
                }
            }
        }
        return jobToExecute.getPhase();
    }

    @Override
    public final synchronized void remove(UWSJob jobToRemove) {
        if (jobToRemove != null) {
            this.runningJobs.remove(jobToRemove.getJobId());
            this.queuedJobs.remove(jobToRemove);
            this.refresh();
        }
    }

    @Override
    public final synchronized void stopAll() {
        for (UWSJob qj : this.queuedJobs) {
            try {
                qj.setPhase(ExecutionPhase.PENDING, true);
            }
            catch (UWSException ue) {
                if (this.logger == null) continue;
                this.logger.logJob(UWSLog.LogLevel.WARNING, qj, "ABORT", "Can not set back the job to the PENDING phase.", ue);
            }
        }
        this.queuedJobs.clear();
        for (UWSJob rj : this.runningJobs.values()) {
            try {
                rj.abort();
                rj.setPhase(ExecutionPhase.PENDING, true);
            }
            catch (UWSException ue) {
                if (this.logger == null) continue;
                this.logger.logJob(UWSLog.LogLevel.WARNING, rj, "ABORT", "Can not stop the job nicely. The thread may continue to run until its end.", ue);
            }
        }
        this.runningJobs.clear();
    }
}

