

import vo.parameter.*;

class Coord
{

   String skySystem;  // FIXME enum ICRS | GALACTIC
   String shape = "CIRCLE";      // FIXME enum CIRCLE | RECT | POLYGON   FIXME replace RECT -> RANGE
   String specSystem; // FIXME enum VELO_LSRK | WAVE_Barycentric | NONE

   Pos  pos;
   Band band;
   Time time;
   Pol  pol;
   String pixels;

   Coord(String skySystem, Pos pos, String specSystem, Band band, Time time, Pol pol, String pixels)
   {
      this.pos  = pos;
      this.band = band;
      this.time = time;
      this.pol  = pol;
      this.pixels  = pixels;

      this.skySystem  = skySystem;
      this.specSystem = specSystem;
   }

   Coord(String skySystem, Pos pos, String specSystem, Band band, Time time, Pol pol)
   {
      this(skySystem, pos, specSystem, band, time, pol, null);
   }
 
   Coord(Pos pos, Band band, Time time, Pol pol, String pixels)
   {
      this( (pos ==null)? null : pos.system.toString(), pos,
            (band==null)? null : band.system.toString(), band,
            time, pol, pixels);
   }
 
}

