#ifndef AST4VL_HPP
#define AST4VL_HPP


#include <string>
#include <vector>

#include "cutout.hpp" // coordinate needed


struct point2d {double lon; double lat;};

struct Bounds
{
   std::string label;
   std::string low_str;
   std::string up_str;
   std::string unit;
   double low;
   double up;
   int naxis;
};

struct uint_bounds
{
   unsigned int pix1;
   unsigned int pix2;
   unsigned char type;
};

struct double_xy
{
   double x;
   double y;
   unsigned char type;
};

struct overlap_ranges
{
   int ov_code;
   std::vector<double_xy> pixel_ranges;
};


std::ostream& operator<<( std::ostream & o, const point2d &a);
std::ostream& operator<<( std::ostream &out, struct Bounds const& p);
std::ostream& operator<<( std::ostream &out, struct uint_bounds const& p);
std::ostream& operator<<( std::ostream &out, overlap_ranges const& p);




std::vector<point2d> calc_skyvertices(std::string header, std::string skysys);

std::vector<Bounds> calc_bounds(std::string header, std::string skysys_str, std::string specsys_str);

std::vector<uint_bounds> calc_overlap(const std::string header, const coordinates coord, int& ov_code);

#endif

