
# how to all vlkbd in Makefile:

# killall -q vlkbd-$(VERNUM); test $$? -eq 1


if [ "$#" -lt 1 ]; then
    echo -e "Run vlkbd-<version> on all CPU-cores, connecting to RabbitMQ on <amqphost>.\nUsage:\n\t $0 <amqphost> <queue_name> <datasets_conf>\n"
    exit
fi

ncores=$(grep '^processor' /proc/cpuinfo | sort -u | wc -l)

AMQPHOST=$1


for core in $(seq 0 $(expr $ncores - 1) )
do

   # FIXME /usr/local should be configurable from engine/Makefile -> INSTALL_DIR
   # or vlkbd_exec.sh sould be under resources and handled together with datasets.conf
   taskset -c $core vlkbd $AMQPHOST 5672 $2 $3

done

ps ax | grep vlkbd



# with bitmask:

# usage: run on 2nd cpu ore
#taskset 0x02 ./vlkb_amqp localhost 5672 test
# run on 1st cpu ore
#taskset 0x01 ./vlkb_amqp localhost 5672 test
# Note that a bitmask uses "hexadecimal" notation. 
# "0x11" is "00010001" in a binary format, which corresponds 
# to CPU core 0 and 4. 
# CPU core 0 and 1 is represented by CPU affinity "0x3".
# taskset $1 ./vlkb_amqp localhost 5672 test


# use defualt exchange
#./amqp_listen localhost 5672 "" "test"
