/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import java.util.Date;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.ImageData;
import nom.tam.fits.RandomGroupsData;
import nom.tam.fits.TableData;
import nom.tam.fits.UndefinedData;
import nom.tam.fits.header.FitsHeaderImpl;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.StandardCommentReplacement;

public enum Standard implements IFitsHeader
{
    AUTHOR(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "author of the data", new StandardCommentReplacement[0]),
    BITPIX(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "bits per data value", Standard.replaceable("header:bitpix", Object.class)),
    BLANK(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.INTEGER, "value used for undefined array elements", new StandardCommentReplacement[0]),
    BLANKS("        ", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, "descriptive comment", new StandardCommentReplacement[0]),
    BLOCKED(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "is physical blocksize a multiple of 2880?", new StandardCommentReplacement[0]),
    BSCALE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "linear factor in scaling equation", new StandardCommentReplacement[0]),
    BUNIT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "physical units of the array values", new StandardCommentReplacement[0]),
    BZERO(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "zero point in scaling equation", new StandardCommentReplacement[0]),
    CDELTn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate increment along axis", new StandardCommentReplacement[0]),
    COMMENT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, "descriptive comment", new StandardCommentReplacement[0]),
    CROTAn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate system rotation angle", new StandardCommentReplacement[0]),
    CRPIXn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate system reference pixel", new StandardCommentReplacement[0]),
    CRVALn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "coordinate system value at reference pixel", new StandardCommentReplacement[0]),
    CTYPEn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.STRING, "name of the coordinate axis", new StandardCommentReplacement[0]),
    DATAMAX(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "maximum data value", new StandardCommentReplacement[0]),
    DATAMIN(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.IMAGE, IFitsHeader.VALUE.REAL, "minimum data value", new StandardCommentReplacement[0]),
    DATE(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "date of file creation", new StandardCommentReplacement[0]),
    DATE_OBS("DATE-OBS", IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "date of the observation", new StandardCommentReplacement[0]),
    END(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, "marks the end of the key keywords", new StandardCommentReplacement[0]),
    EPOCH(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "equinox of celestial coordinate system", new StandardCommentReplacement[0]),
    EQUINOX(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.REAL, "equinox of celestial coordinate system", new StandardCommentReplacement[0]),
    EXTEND(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "may the FITS file contain extensions?", Standard.replaceable("basichdu:extend", BasicHDU.class, "Allow extensions"), Standard.replaceable("header:extend", Object.class, "Extensions are permitted"), Standard.replaceable("imagedata:extend", ImageData.class, "Extension permitted"), Standard.replaceable("undefineddata:extend", UndefinedData.class, "Extensions are permitted")),
    EXTLEVEL(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.INTEGER, "hierarchical level of the extension", new StandardCommentReplacement[0]),
    EXTNAME(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.STRING, "name of the extension", new StandardCommentReplacement[0]),
    EXTVER(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.INTEGER, "version of the extension", new StandardCommentReplacement[0]),
    GCOUNT(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.INTEGER, "group count", Standard.replaceable("randomgroupsdata:gcount", RandomGroupsData.class), Standard.replaceable("asciitable:gcount", AsciiTable.class), Standard.replaceable("basichdu:gcount", Object.class, "Required value"), Standard.replaceable("binarytable:gcount", BinaryTable.class), Standard.replaceable("imagedata:gcount", ImageData.class, "No extra parameters"), Standard.replaceable("undefineddata:gcount", UndefinedData.class)),
    GROUPS(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.LOGICAL, "indicates random groups structure", Standard.replaceable("randomgroupsdata:groups", RandomGroupsData.class)),
    HISTORY(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.NONE, "processing history of the data", new StandardCommentReplacement[0]),
    INSTRUME(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of instrument", new StandardCommentReplacement[0]),
    NAXIS(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "number of axes", Standard.replaceable("header:naxis", Object.class)),
    NAXISn(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.INTEGER, "size of the n'th axis", Standard.replaceable("asciitable:naxis1", AsciiTable.class, "Size of row in bytes"), Standard.replaceable("binarytable:naxis1", BinaryTable.class, "Bytes per row"), Standard.replaceable("randomgroupsdata:naxis1", RandomGroupsData.class), Standard.replaceable("randomgroupsdata:naxisN", RandomGroupsData.class), Standard.replaceable("tablehdu:naxis2", TableData.class), Standard.replaceable("header:naxisN", Object.class), Standard.replaceable("undefineddata:naxis1", UndefinedData.class, "Number of Bytes")),
    OBJECT(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of observed object", new StandardCommentReplacement[0]),
    OBSERVER(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "observer who acquired the data", new StandardCommentReplacement[0]),
    ORIGIN(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "organization responsible for the data", new StandardCommentReplacement[0]),
    PCOUNT(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.INTEGER, "parameter count", Standard.replaceable("asciitable:pcount", AsciiTable.class, "No group data"), Standard.replaceable("basichdu:pcount", Object.class, "Required value"), Standard.replaceable("binarytablehdu:pcount", BinaryTable.class, "Includes heap"), Standard.replaceable("binarytable:pcount", BinaryTable.class), Standard.replaceable("imagedata:pcount", ImageData.class, "One group"), Standard.replaceable("randomgroupsdata:pcount", RandomGroupsData.class), Standard.replaceable("undefineddata:pcount", UndefinedData.class)),
    PSCALn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.REAL, "parameter scaling factor", new StandardCommentReplacement[0]),
    PTYPEn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.STRING, "name of random groups parameter", new StandardCommentReplacement[0]),
    PZEROn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.GROUPS, IFitsHeader.VALUE.REAL, "parameter scaling zero point", new StandardCommentReplacement[0]),
    RADESYS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "Coordinate reference frame of major/minor axes.", new StandardCommentReplacement[0]),
    RADECSYS(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "Coordinate reference frame of major/minor axes.", new StandardCommentReplacement[0]),
    REFERENC(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "bibliographic reference", new StandardCommentReplacement[0]),
    SIMPLE(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.PRIMARY, IFitsHeader.VALUE.LOGICAL, "does file conform to the Standard?", Standard.replaceable("header:simple", Object.class, "Java FITS: " + new Date())),
    TBCOLn(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.ASCII_TABLE, IFitsHeader.VALUE.INTEGER, "begining column number", Standard.replaceable("asciitable:tbcolN", AsciiTable.class, "Column offset")),
    TDIMn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.BINTABLE, IFitsHeader.VALUE.STRING, "dimensionality of the array ", Standard.replaceable("binarytablehdu:tdimN", BinaryTable.class), Standard.replaceable("headercard:tdimN", Object.class)),
    TDISPn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "display format", new StandardCommentReplacement[0]),
    TELESCOP(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.ANY, IFitsHeader.VALUE.STRING, "name of telescope", new StandardCommentReplacement[0]),
    TFIELDS(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.INTEGER, "number of columns in the table", Standard.replaceable("asciitablehdu:tfields", AsciiTable.class), Standard.replaceable("binarytable:tfields", BinaryTable.class), Standard.replaceable("tablehdu:tfields", TableData.class, "Number of table fields"), Standard.replaceable("asciitable:tfields", AsciiTable.class, "Number of fields in table")),
    TFORMn(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column data format", Standard.replaceable("asciitable:tformN", AsciiTable.class), Standard.replaceable("binarytable:tformN", BinaryTable.class)),
    THEAP(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.BINTABLE, IFitsHeader.VALUE.INTEGER, "offset to starting data heap address", Standard.replaceable("binarytablehdu:theap", BinaryTable.class)),
    TNULLn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "value used to indicate undefined table element", new StandardCommentReplacement[0]),
    TSCALn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "linear data scaling factor", new StandardCommentReplacement[0]),
    TTYPEn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column name", new StandardCommentReplacement[0]),
    TUNITn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.STRING, "column units", new StandardCommentReplacement[0]),
    TZEROn(IFitsHeader.SOURCE.RESERVED, IFitsHeader.HDU.TABLE, IFitsHeader.VALUE.REAL, "column scaling zero point", new StandardCommentReplacement[0]),
    XTENSION(IFitsHeader.SOURCE.MANDATORY, IFitsHeader.HDU.EXTENSION, IFitsHeader.VALUE.STRING, "marks beginning of new HDU", new StandardCommentReplacement[0]);

    public static final IFitsHeader NAXIS1;
    public static final IFitsHeader NAXIS2;
    private static final ThreadLocal<Class<?>> COMMENT_CONTEXT;
    private final StandardCommentReplacement[] commentReplacements;
    private final IFitsHeader key;

    private Standard(IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment, StandardCommentReplacement ... replacements) {
        this.key = new FitsHeaderImpl(this.name(), status, hdu, valueType, comment);
        this.commentReplacements = replacements;
    }

    private Standard(String headerName, IFitsHeader.SOURCE status, IFitsHeader.HDU hdu, IFitsHeader.VALUE valueType, String comment, StandardCommentReplacement ... replacements) {
        this.key = new FitsHeaderImpl(headerName == null ? this.name() : headerName, status, hdu, valueType, comment);
        this.commentReplacements = replacements;
    }

    @Override
    public String comment() {
        Class<Object> contextClass = COMMENT_CONTEXT.get();
        if (contextClass == null) {
            contextClass = Object.class;
        }
        for (StandardCommentReplacement stdCommentReplacement : this.commentReplacements) {
            if (!stdCommentReplacement.getContext().isAssignableFrom(contextClass) || stdCommentReplacement.getComment() == null) continue;
            return stdCommentReplacement.getComment();
        }
        return this.key.comment();
    }

    @Override
    public IFitsHeader.HDU hdu() {
        return this.key.hdu();
    }

    @Override
    public String key() {
        return this.key.key();
    }

    @Override
    public IFitsHeader n(int ... number) {
        return this.key.n(number);
    }

    @Override
    public IFitsHeader.SOURCE status() {
        return this.key.status();
    }

    @Override
    public IFitsHeader.VALUE valueType() {
        return this.key.valueType();
    }

    public static void context(Class<?> clazz) {
        COMMENT_CONTEXT.set(clazz);
    }

    public String getCommentByKey(String commentKey) {
        for (StandardCommentReplacement commentReplacement : this.commentReplacements) {
            if (!commentReplacement.getRef().equals(commentKey)) continue;
            String foundcommentReplacement = commentReplacement.getComment();
            if (foundcommentReplacement == null) {
                return this.comment();
            }
            return foundcommentReplacement;
        }
        return null;
    }

    public void setCommentByKey(String commentKey, String value) {
        for (StandardCommentReplacement commentReplacement : this.commentReplacements) {
            if (!commentReplacement.getRef().equals(commentKey)) continue;
            commentReplacement.setComment(value);
            return;
        }
    }

    private static StandardCommentReplacement replaceable(String string, Class<?> clazz) {
        return new StandardCommentReplacement(string, clazz);
    }

    private static StandardCommentReplacement replaceable(String string, Class<?> clazz, String comment) {
        return new StandardCommentReplacement(string, clazz, comment);
    }

    static {
        NAXIS1 = NAXISn.n(1);
        NAXIS2 = NAXISn.n(2);
        COMMENT_CONTEXT = new ThreadLocal();
    }
}

