/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TableHDU;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.Cursor;

public class AsciiTableHDU
extends TableHDU<AsciiTable> {
    private static final Logger LOG = Logger.getLogger(AsciiTableHDU.class.getName());
    private static final IFitsHeader[] KEY_STEMS = new IFitsHeader[]{Standard.TFORMn, Standard.TZEROn, Standard.TNULLn, Standard.TTYPEn, Standard.TUNITn};

    public static AsciiTable encapsulate(Object o) throws FitsException {
        Object[] oo = (Object[])o;
        AsciiTable d = new AsciiTable();
        for (Object element : oo) {
            d.addColumn(element);
        }
        return d;
    }

    public static boolean isData(Object o) {
        if (o instanceof Object[]) {
            Object[] oo;
            for (Object element : oo = (Object[])o) {
                if (element instanceof String[] || element instanceof int[] || element instanceof long[] || element instanceof float[] || element instanceof double[]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHeader(Header header) {
        return header.getStringValue(Standard.XTENSION).trim().equals("TABLE");
    }

    public static Data manufactureData(Header hdr) throws FitsException {
        return new AsciiTable(hdr);
    }

    public static Header manufactureHeader(Data d) throws FitsException {
        Header hdr = new Header();
        d.fillHeader(hdr);
        hdr.iterator();
        return hdr;
    }

    public AsciiTableHDU(Header h, AsciiTable d) {
        super(h, d);
    }

    @Override
    public int addColumn(Object newCol) throws FitsException {
        Standard.context(AsciiTable.class);
        ((AsciiTable)this.myData).addColumn(newCol);
        Cursor<String, HeaderCard> iter = this.myHeader.positionAfterIndex(Standard.TBCOLn, ((AsciiTable)this.myData).getNCols());
        int rowlen = ((AsciiTable)this.myData).addColInfo(this.getNCols() - 1, iter);
        int oldRowlen = this.myHeader.getIntValue(Standard.NAXIS1);
        this.myHeader.setNaxis(1, rowlen + oldRowlen);
        super.addColumn(newCol);
        Standard.context(null);
        return this.getNCols();
    }

    @Override
    protected IFitsHeader[] columnKeyStems() {
        return KEY_STEMS;
    }

    @Override
    public void info(PrintStream stream) {
        stream.println("ASCII Table:");
        stream.println("  Header:");
        stream.println("    Number of fields:" + this.myHeader.getIntValue(Standard.TFIELDS));
        stream.println("    Number of rows:  " + this.myHeader.getIntValue(Standard.NAXIS2));
        stream.println("    Length of row:   " + this.myHeader.getIntValue(Standard.NAXIS1));
        stream.println("  Data:");
        Object[] data = (Object[])this.getKernel();
        for (int i = 0; i < this.getNCols(); ++i) {
            stream.println("      " + i + ":" + ArrayFuncs.arrayDescription(data[i]));
        }
    }

    public boolean isNull(int row, int col) {
        return ((AsciiTable)this.myData).isNull(row, col);
    }

    public void setNull(int row, int col, boolean flag) {
        String nullStr;
        if (flag && (nullStr = this.myHeader.getStringValue(Standard.TNULLn.n(col + 1))) == null) {
            this.setNullString(col, "NULL");
        }
        ((AsciiTable)this.myData).setNull(row, col, flag);
    }

    public void setNullString(int col, String newNull) {
        this.myHeader.positionAfterIndex(Standard.TBCOLn, col + 1);
        try {
            this.myHeader.addValue(Standard.TNULLn.n(col + 1), newNull);
        }
        catch (HeaderCardException e) {
            LOG.log(Level.SEVERE, "Impossible exception in setNullString" + e);
        }
        ((AsciiTable)this.myData).setNullString(col, newNull);
    }
}

