/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.quant;

import java.util.Arrays;
import nom.tam.fits.compression.algorithm.quant.QuantizeOption;

public class Quantize {
    private static final double DEFAULT_QUANT_LEVEL = 4.0;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;
    private static final int MINIMUM_PIXEL_WIDTH = 9;
    private static final long N_RESERVED_VALUES = 10L;
    private static final int N4 = 4;
    private static final int N6 = 6;
    private static final double NOISE_2_MULTIPLICATOR = 1.0483579;
    private static final double NOISE_3_MULTIPLICATOR = 0.6052697;
    private static final double NOISE_5_MULTIPLICATOR = 0.1772048;
    private final QuantizeOption parameter;
    private double maxValue;
    private double minValue;
    private long ngood;
    private double noise2;
    private double noise3;
    private double noise5;
    private double xmaxval;
    private double xminval;
    private double xnoise2;
    private double xnoise3;
    private double xnoise5;

    public Quantize(QuantizeOption quantizeOption) {
        this.parameter = quantizeOption;
    }

    private void calculateNoise(double[] arrayIn, int nx, int ny) {
        DoubleArrayPointer array = new DoubleArrayPointer(arrayIn);
        this.initializeNoise();
        if (nx < 9) {
            nx *= ny;
            ny = 1;
        }
        if (this.calculateNoiseShortRow(array, nx, ny)) {
            return;
        }
        int nrows = 0;
        int nrows2 = 0;
        long ngoodpix = 0L;
        double[] differences2 = new double[nx];
        double[] differences3 = new double[nx];
        double[] differences5 = new double[nx];
        double[] diffs2 = new double[ny];
        double[] diffs3 = new double[ny];
        double[] diffs5 = new double[ny];
        for (int jj = 0; jj < ny; ++jj) {
            DoubleArrayPointer rowpix = array.copy(jj * nx);
            int ii = 0;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v1 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            ++ii;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v2 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            ++ii;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v3 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            ++ii;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v4 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            ++ii;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v5 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            ++ii;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v6 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            ++ii;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v7 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            ++ii;
            if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) == nx) continue;
            double v8 = this.getNextPixelAndCheckMinMax(rowpix, ii);
            ++ngoodpix;
            int nvals = 0;
            int nvals2 = 0;
            ++ii;
            while (ii < nx) {
                if ((ii = this.findNextValidPixelWithNullCheck(nx, rowpix, ii)) != nx) {
                    double v9 = this.getNextPixelAndCheckMinMax(rowpix, ii);
                    if (v5 != v6 || v6 != v7) {
                        differences2[nvals2] = Math.abs(v5 - v7);
                        ++nvals2;
                    }
                    if (v3 != v4 || v4 != v5 || v5 != v6 || v6 != v7) {
                        differences3[nvals] = Math.abs(2.0 * v5 - v3 - v7);
                        differences5[nvals] = Math.abs(6.0 * v5 - 4.0 * v3 - 4.0 * v7 + v1 + v9);
                        ++nvals;
                    } else {
                        ++ngoodpix;
                    }
                    v1 = v2;
                    v2 = v3;
                    v3 = v4;
                    v4 = v5;
                    v5 = v6;
                    v6 = v7;
                    v7 = v8;
                    v8 = v9;
                }
                ++ii;
            }
            ngoodpix += (long)nvals;
            if (nvals == 0) continue;
            if (nvals == 1) {
                if (nvals2 == 1) {
                    diffs2[nrows2] = differences2[0];
                    ++nrows2;
                }
                diffs3[nrows] = differences3[0];
                diffs5[nrows] = differences5[0];
            } else {
                if (nvals2 > 1) {
                    diffs2[nrows2] = this.quickSelect(differences2, nvals);
                    ++nrows2;
                }
                diffs3[nrows] = this.quickSelect(differences3, nvals);
                diffs5[nrows] = this.quickSelect(differences5, nvals);
            }
            ++nrows;
        }
        this.computeMedianOfValuesEachRow(nrows, nrows2, diffs2, diffs3, diffs5);
        this.setNoiseResult(ngoodpix);
    }

    private boolean calculateNoiseShortRow(DoubleArrayPointer array, int nx, int ny) {
        if (nx < 9) {
            int ngoodpix = 0;
            for (int index = 0; index < nx; ++index) {
                if (this.isNull(array.get(index))) continue;
                if (array.get(index) < this.xminval) {
                    this.xminval = array.get(index);
                }
                if (array.get(index) > this.xmaxval) {
                    this.xmaxval = array.get(index);
                }
                ++ngoodpix;
            }
            this.setNoiseResult(ngoodpix);
            return true;
        }
        return false;
    }

    protected void computeMedianOfValuesEachRow(int nrows, int nrows2, double[] diffs2, double[] diffs3, double[] diffs5) {
        if (nrows == 0) {
            this.xnoise3 = 0.0;
            this.xnoise5 = 0.0;
        } else if (nrows == 1) {
            this.xnoise3 = diffs3[0];
            this.xnoise5 = diffs5[0];
        } else {
            Arrays.sort(diffs3, 0, nrows);
            Arrays.sort(diffs5, 0, nrows);
            this.xnoise3 = (diffs3[(nrows - 1) / 2] + diffs3[nrows / 2]) / 2.0;
            this.xnoise5 = (diffs5[(nrows - 1) / 2] + diffs5[nrows / 2]) / 2.0;
        }
        if (nrows2 == 0) {
            this.xnoise2 = 0.0;
        } else if (nrows2 == 1) {
            this.xnoise2 = diffs2[0];
        } else {
            Arrays.sort(diffs2, 0, nrows2);
            this.xnoise2 = (diffs2[(nrows2 - 1) / 2] + diffs2[nrows2 / 2]) / 2.0;
        }
    }

    protected int findNextValidPixelWithNullCheck(int nx, DoubleArrayPointer rowpix, int ii) {
        return ii;
    }

    private double getNextPixelAndCheckMinMax(DoubleArrayPointer rowpix, int ii) {
        double pixelValue = rowpix.get(ii);
        if (pixelValue < this.xminval) {
            this.xminval = pixelValue;
        }
        if (pixelValue > this.xmaxval) {
            this.xmaxval = pixelValue;
        }
        return pixelValue;
    }

    protected double getNoise2() {
        return this.noise2;
    }

    protected double getNoise3() {
        return this.noise3;
    }

    protected double getNoise5() {
        return this.noise5;
    }

    private void initializeNoise() {
        this.xnoise2 = 0.0;
        this.xnoise3 = 0.0;
        this.xnoise5 = 0.0;
        this.xminval = Double.MAX_VALUE;
        this.xmaxval = Double.MIN_VALUE;
    }

    protected boolean isNull(double d) {
        return false;
    }

    public boolean quantize(double[] fdata, int nxpix, int nypix) {
        double bScale;
        long nx = (long)nxpix * (long)nypix;
        if (nx <= 1L) {
            this.parameter.setBScale(1.0);
            this.parameter.setBZero(0.0);
            return false;
        }
        if (this.parameter.getQLevel() >= 0.0) {
            double stdev;
            this.calculateNoise(fdata, nxpix, nypix);
            if (this.parameter.isCheckNull() && this.ngood == 0L) {
                this.minValue = 0.0;
                this.maxValue = 1.0;
                stdev = 1.0;
            } else {
                stdev = this.noise3;
                if (this.noise2 != 0.0 && this.noise2 < stdev) {
                    stdev = this.noise2;
                }
                if (this.noise5 != 0.0 && this.noise5 < stdev) {
                    stdev = this.noise5;
                }
            }
            bScale = this.parameter.getQLevel() == 0.0 ? stdev / 4.0 : stdev / this.parameter.getQLevel();
            if (bScale == 0.0) {
                return false;
            }
        } else {
            bScale = -this.parameter.getQLevel();
            this.calculateNoise(fdata, nxpix, nypix);
        }
        if ((this.maxValue - this.minValue) / bScale > 4.294967284E9) {
            return false;
        }
        this.parameter.setBScale(bScale);
        this.parameter.setMinValue(this.minValue);
        this.parameter.setMaxValue(this.maxValue);
        this.parameter.setCheckNull(this.parameter.isCheckNull() && this.ngood != nx);
        return true;
    }

    private double quickSelect(double[] arr, int n) {
        int low = 0;
        int high = n - 1;
        int median = low + high >>> 1;
        while (high > low) {
            if (high == low + 1) {
                if (arr[low] > arr[high]) {
                    this.swapElements(arr, low, high);
                }
                return arr[median];
            }
            int middle = low + high >>> 1;
            if (arr[middle] > arr[high]) {
                this.swapElements(arr, middle, high);
            }
            if (arr[low] > arr[high]) {
                this.swapElements(arr, low, high);
            }
            if (arr[middle] > arr[low]) {
                this.swapElements(arr, middle, low);
            }
            this.swapElements(arr, middle, low + 1);
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (arr[low] > arr[++ll]) {
                    continue;
                }
                while (arr[--hh] > arr[low]) {
                }
                if (hh < ll) break;
                this.swapElements(arr, ll, hh);
            }
            this.swapElements(arr, low, hh);
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return arr[median];
    }

    private void setNoiseResult(long ngoodpix) {
        this.minValue = this.xminval;
        this.maxValue = this.xmaxval;
        this.ngood = ngoodpix;
        this.noise2 = 1.0483579 * this.xnoise2;
        this.noise3 = 0.6052697 * this.xnoise3;
        this.noise5 = 0.1772048 * this.xnoise5;
    }

    private void swapElements(double[] array, int one, int second) {
        double value = array[one];
        array[one] = array[second];
        array[second] = value;
    }

    class DoubleArrayPointer {
        private final double[] array;
        private int startIndex;

        DoubleArrayPointer(double[] arrayIn) {
            this.array = arrayIn;
        }

        public DoubleArrayPointer copy(long l) {
            DoubleArrayPointer result = new DoubleArrayPointer(this.array);
            result.startIndex = (int)l;
            return result;
        }

        public double get(int ii) {
            return this.array[ii + this.startIndex];
        }
    }
}

