/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util.type;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import nom.tam.util.type.PrimitiveTypeBase;

class LongType
extends PrimitiveTypeBase<LongBuffer> {
    private static final int BIT_PIX = 64;
    private static final int SIZE = 8;

    protected LongType() {
        super(8, false, Long.TYPE, Long.class, LongBuffer.class, 'J', 64);
    }

    @Override
    public void appendBuffer(LongBuffer buffer, LongBuffer dataToAppend) {
        long[] temp = new long[Math.min(1024, dataToAppend.remaining())];
        while (dataToAppend.hasRemaining()) {
            int nrObBytes = Math.min(temp.length, dataToAppend.remaining());
            dataToAppend.get(temp, 0, nrObBytes);
            buffer.put(temp, 0, nrObBytes);
        }
    }

    @Override
    public LongBuffer asTypedBuffer(ByteBuffer buffer) {
        return buffer.asLongBuffer();
    }

    @Override
    public void getArray(LongBuffer buffer, Object array, int length) {
        buffer.get((long[])array, 0, length);
    }

    @Override
    public Object newArray(int length) {
        return new long[length];
    }

    @Override
    public void putArray(LongBuffer buffer, Object array, int length) {
        buffer.put((long[])array, 0, length);
    }

    @Override
    public LongBuffer sliceBuffer(LongBuffer buffer) {
        return buffer.slice();
    }

    @Override
    public LongBuffer wrap(Object array) {
        return LongBuffer.wrap((long[])array);
    }
}

