/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ReplicationConnection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReplicationConnectionGroup {
    private String groupName;
    private long connections = 0L;
    private long slavesAdded = 0L;
    private long slavesRemoved = 0L;
    private long slavesPromoted = 0L;
    private long activeConnections = 0L;
    private HashMap<Long, ReplicationConnection> replicationConnections = new HashMap();
    private Set<String> slaveHostList = new HashSet<String>();
    private boolean isInitialized = false;
    private Set<String> masterHostList = new HashSet<String>();

    ReplicationConnectionGroup(String groupName) {
        this.groupName = groupName;
    }

    public long getConnectionCount() {
        return this.connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerReplicationConnection(ReplicationConnection conn, List<String> localMasterList, List<String> localSlaveList) {
        long currentConnectionId;
        ReplicationConnectionGroup replicationConnectionGroup = this;
        synchronized (replicationConnectionGroup) {
            if (!this.isInitialized) {
                if (localMasterList != null) {
                    this.masterHostList.addAll(localMasterList);
                }
                if (localSlaveList != null) {
                    this.slaveHostList.addAll(localSlaveList);
                }
                this.isInitialized = true;
            }
            currentConnectionId = ++this.connections;
            this.replicationConnections.put(currentConnectionId, conn);
        }
        ++this.activeConnections;
        return currentConnectionId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Collection<String> getMasterHosts() {
        return this.masterHostList;
    }

    public Collection<String> getSlaveHosts() {
        return this.slaveHostList;
    }

    public void addSlaveHost(String host) throws SQLException {
        if (this.slaveHostList.add(host)) {
            ++this.slavesAdded;
        }
        for (ReplicationConnection c : this.replicationConnections.values()) {
            c.addSlaveHost(host);
        }
    }

    public void handleCloseConnection(ReplicationConnection conn) {
        this.replicationConnections.remove(conn.getConnectionGroupId());
        --this.activeConnections;
    }

    public void removeSlaveHost(String host, boolean closeGently) throws SQLException {
        if (this.slaveHostList.remove(host)) {
            ++this.slavesRemoved;
        }
        for (ReplicationConnection c : this.replicationConnections.values()) {
            c.removeSlave(host, closeGently);
        }
    }

    public void promoteSlaveToMaster(String host) throws SQLException {
        this.slaveHostList.remove(host);
        this.masterHostList.add(host);
        for (ReplicationConnection c : this.replicationConnections.values()) {
            c.promoteSlaveToMaster(host);
        }
        ++this.slavesPromoted;
    }

    public void removeMasterHost(String host) throws SQLException {
        this.removeMasterHost(host, true);
    }

    public void removeMasterHost(String host, boolean closeGently) throws SQLException {
        if (this.masterHostList.remove(host)) {
            // empty if block
        }
        for (ReplicationConnection c : this.replicationConnections.values()) {
            c.removeMasterHost(host, closeGently);
        }
    }

    public int getConnectionCountWithHostAsSlave(String host) {
        int matched = 0;
        for (ReplicationConnection c : this.replicationConnections.values()) {
            if (!c.isHostSlave(host)) continue;
            ++matched;
        }
        return matched;
    }

    public int getConnectionCountWithHostAsMaster(String host) {
        int matched = 0;
        for (ReplicationConnection c : this.replicationConnections.values()) {
            if (!c.isHostMaster(host)) continue;
            ++matched;
        }
        return matched;
    }

    public long getNumberOfSlavesAdded() {
        return this.slavesAdded;
    }

    public long getNumberOfSlavesRemoved() {
        return this.slavesRemoved;
    }

    public long getNumberOfSlavePromotions() {
        return this.slavesPromoted;
    }

    public long getTotalConnectionCount() {
        return this.connections;
    }

    public long getActiveConnectionCount() {
        return this.activeConnections;
    }
}

