/*
 * Decompiled with CFR 0.152.
 */
package uws.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.config.UWSConfiguration;
import uws.job.ErrorSummary;
import uws.job.JobThread;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.jobInfo.JobInfo;
import uws.job.parameters.DestructionTimeController;
import uws.job.parameters.DurationParamController;
import uws.job.parameters.ExecutionDurationController;
import uws.job.parameters.InputParamController;
import uws.job.parameters.NumericParamController;
import uws.job.parameters.StringParamController;
import uws.job.parameters.UWSParameters;
import uws.job.user.JobOwner;
import uws.service.UWSFactory;
import uws.service.UWSUrl;
import uws.service.file.UWSFileManager;
import uws.service.request.RequestParser;
import uws.service.request.UWSRequestParser;

public class ConfigurableUWSFactory
implements UWSFactory {
    protected Constructor<? extends RequestParser> constructorRequestParser = null;
    protected Map<String, Constructor<? extends JobThread>> jobThreads = new HashMap<String, Constructor<? extends JobThread>>(2);
    protected Map<String, Map<String, InputParamController>> jobParams = new HashMap<String, Map<String, InputParamController>>(2);
    protected static final Pattern PATTERN_PARAMETER = Pattern.compile("\\s*(\\[([^,]+),(\\s*(\\{[^\\}]*\\})|([^,]*),(\\s*(numeric|duration)\\s*,([^,]*),([^,]*),([^,]*)|\\s*(string)\\s*,\\s*\"([^\"]*)\"\\s*,\\s*/(([^/]|//)*)/(i)?))\\s*\\]|([^,\\[\\]]*))\\s*(,(.*))?", 2);

    protected ConfigurableUWSFactory() {
    }

    public ConfigurableUWSFactory(Properties uwsConfig) throws UWSException {
        String propValue = UWSConfiguration.getProperty(uwsConfig, "request_parser");
        if (propValue != null) {
            this.constructorRequestParser = UWSConfiguration.fetchConstructor(propValue, "request_parser", RequestParser.class, new Class[]{UWSFileManager.class});
        }
        String jlName = null;
        DurationParamController durationController = new DurationParamController();
        Enumeration<?> propNames = uwsConfig.propertyNames();
        while (propNames.hasMoreElements()) {
            InputParamController controller;
            Map<Object, Object> mapControllers;
            String propName = (String)propNames.nextElement();
            if (propName.matches("[^\\.=\\s]+\\.job_thread")) {
                jlName = UWSConfiguration.extractJobListName(propName);
                propValue = UWSConfiguration.getProperty(uwsConfig, propName);
                this.jobThreads.put(jlName, UWSConfiguration.fetchConstructor(propValue, propName, JobThread.class, new Class[]{UWSJob.class}));
                continue;
            }
            if (propName.matches("[^\\.=\\s]+\\.job_parameters")) {
                jlName = UWSConfiguration.extractJobListName(propName);
                propValue = UWSConfiguration.getProperty(uwsConfig, propName);
                this.initParameters(jlName, propValue);
                continue;
            }
            if (propName.matches("[^\\.=\\s]+\\.default_execution_duration")) {
                jlName = UWSConfiguration.extractJobListName(propName);
                propValue = UWSConfiguration.getProperty(uwsConfig, propName);
                try {
                    mapControllers = this.jobParams.containsKey(jlName) ? this.jobParams.get(jlName) : new HashMap();
                    controller = mapControllers.get("executionDuration") != null && mapControllers.get("executionDuration") instanceof ExecutionDurationController ? (ExecutionDurationController)mapControllers.get("executionDuration") : new ExecutionDurationController();
                    controller.setDefaultExecutionDuration(durationController.parseDuration(propValue) / 1000L);
                    mapControllers.put("executionDuration", controller);
                    this.jobParams.put(jlName, mapControllers);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new UWSException("Wrong numeric format for the default execution duration: \"" + propValue + "\"!");
                }
                catch (ParseException pe) {
                    throw new UWSException("Incorrect syntax for the default execution duration! Cause: " + pe.getMessage());
                }
            }
            if (propName.matches("[^\\.=\\s]+\\.max_execution_duration")) {
                jlName = UWSConfiguration.extractJobListName(propName);
                propValue = UWSConfiguration.getProperty(uwsConfig, propName);
                try {
                    mapControllers = this.jobParams.containsKey(jlName) ? this.jobParams.get(jlName) : new HashMap();
                    controller = mapControllers.get("executionDuration") != null && mapControllers.get("executionDuration") instanceof ExecutionDurationController ? (ExecutionDurationController)mapControllers.get("executionDuration") : new ExecutionDurationController();
                    controller.setMaxExecutionDuration(durationController.parseDuration(propValue) / 1000L);
                    mapControllers.put("executionDuration", controller);
                    this.jobParams.put(jlName, mapControllers);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new UWSException("Wrong numeric format for the maximum execution duration: \"" + propValue + "\"!");
                }
                catch (ParseException pe) {
                    throw new UWSException("Incorrect syntax for the maximum execution duration! Cause: " + pe.getMessage());
                }
            }
            if (propName.matches("[^\\.=\\s]+\\.default_destruction_interval")) {
                jlName = UWSConfiguration.extractJobListName(propName);
                propValue = UWSConfiguration.getProperty(uwsConfig, propName);
                try {
                    mapControllers = this.jobParams.containsKey(jlName) ? this.jobParams.get(jlName) : new HashMap();
                    controller = mapControllers.get("destruction") != null && mapControllers.get("destruction") instanceof DestructionTimeController ? (DestructionTimeController)mapControllers.get("destruction") : new DestructionTimeController();
                    ((DestructionTimeController)controller).setDefaultDestructionInterval((int)durationController.parseDuration(propValue));
                    mapControllers.put("destruction", controller);
                    this.jobParams.put(jlName, mapControllers);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new UWSException("Wrong numeric format for the default destruction time: \"" + propValue + "\"!");
                }
                catch (ParseException pe) {
                    throw new UWSException("Incorrect syntax for the default destruction time! Cause: " + pe.getMessage());
                }
            }
            if (!propName.matches("[^\\.=\\s]+\\.max_destruction_interval")) continue;
            jlName = UWSConfiguration.extractJobListName(propName);
            propValue = UWSConfiguration.getProperty(uwsConfig, propName);
            try {
                mapControllers = this.jobParams.containsKey(jlName) ? this.jobParams.get(jlName) : new HashMap();
                controller = mapControllers.get("destruction") != null && mapControllers.get("destruction") instanceof DestructionTimeController ? (DestructionTimeController)mapControllers.get("destruction") : new DestructionTimeController();
                ((DestructionTimeController)controller).setMaxDestructionInterval((int)durationController.parseDuration(propValue));
                mapControllers.put("destruction", controller);
                this.jobParams.put(jlName, mapControllers);
            }
            catch (NumberFormatException nfe) {
                throw new UWSException("Wrong numeric format for the maximum destruction time: \"" + propValue + "\"!");
            }
            catch (ParseException pe) {
                throw new UWSException("Incorrect syntax for the maximum destruction time! Cause: " + pe.getMessage());
            }
        }
    }

    protected void initParameters(String jlName, String propValue) throws UWSException {
        Map<String, InputParamController> jlParameters = this.jobParams.get(jlName);
        if (jlParameters == null) {
            jlParameters = new HashMap<String, InputParamController>();
        }
        int indParameter = 1;
        String remaining = propValue;
        boolean modif = true;
        while (remaining != null && remaining.trim().length() > 0) {
            String paramName;
            Matcher matcher = PATTERN_PARAMETER.matcher(remaining);
            if (!matcher.matches()) {
                throw new UWSException("Incorrect parameter list syntax from the parameter N\u00b0" + indParameter + ": " + remaining);
            }
            if (matcher.group(16) != null) {
                paramName = matcher.group(16).trim();
                if (paramName.length() > 0) {
                    if (!paramName.replaceFirst("\\s", "_").equals(paramName)) {
                        throw new UWSException("Incorrect syntax for the parameter name \"" + paramName + "\"! Space characters are forbidden.");
                    }
                    jlParameters.put(paramName, null);
                }
            } else {
                paramName = matcher.group(2).trim();
                if (paramName.length() == 0) {
                    throw new UWSException("Missing name for the parameter N\u00b0" + indParameter + "!");
                }
                if (!paramName.replaceFirst("\\s", "_").equals(paramName)) {
                    throw new UWSException("Incorrect syntax for the parameter name \"" + paramName + "\"! Space characters are forbidden.");
                }
                if (matcher.group(4) != null) {
                    jlParameters.put(paramName, UWSConfiguration.newInstance(matcher.group(4), jlName + "." + "job_parameters", InputParamController.class, new Class[0], new Object[0]));
                } else {
                    InputParamController controller;
                    String temp = matcher.group(5).trim();
                    modif = temp.length() == 0 || temp.matches("(?i)(true|t|yes|y)");
                    if (matcher.group(11) != null) {
                        controller = new StringParamController(paramName);
                        ((StringParamController)controller).allowModification(modif);
                        if (matcher.group(12).length() > 0) {
                            ((StringParamController)controller).setDefaultValue(matcher.group(12));
                        }
                        if (matcher.group(13).length() > 0) {
                            ((StringParamController)controller).setRegExp((matcher.group(15) != null ? "(?i)" : "") + matcher.group(13));
                        }
                        jlParameters.put(paramName, controller);
                    } else if (matcher.group(7) != null) {
                        if (matcher.group(7).trim().equalsIgnoreCase("numeric")) {
                            controller = new NumericParamController();
                            ((NumericParamController)controller).allowModification(modif);
                            if (matcher.group(8).trim().length() > 0) {
                                try {
                                    ((NumericParamController)controller).setDefault(Double.parseDouble(matcher.group(8).trim()));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new UWSException("Wrong numeric format for the default value of the parameter \"" + paramName + "\": \"" + matcher.group(8).trim() + "\"!");
                                }
                            }
                            if (matcher.group(9).trim().length() > 0) {
                                try {
                                    ((NumericParamController)controller).setMinimum(Double.parseDouble(matcher.group(9).trim()));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new UWSException("Wrong numeric format for the minimum value of the parameter \"" + paramName + "\": \"" + matcher.group(9).trim() + "\"!");
                                }
                            }
                            if (matcher.group(10).trim().length() > 0) {
                                try {
                                    ((NumericParamController)controller).setMaximum(Double.parseDouble(matcher.group(10).trim()));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new UWSException("Wrong numeric format for the maximum value of the parameter \"" + paramName + "\": \"" + matcher.group(10).trim() + "\"!");
                                }
                            }
                            jlParameters.put(paramName, controller);
                        } else {
                            controller = new DurationParamController();
                            ((NumericParamController)controller).allowModification(modif);
                            if (matcher.group(8).trim().length() > 0) {
                                try {
                                    ((DurationParamController)controller).setDefault(((DurationParamController)controller).parseDuration(matcher.group(8).trim()));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new UWSException("Wrong numeric format for the default value of the parameter \"" + paramName + "\": \"" + matcher.group(8).trim() + "\"!");
                                }
                                catch (ParseException pe) {
                                    throw new UWSException("Incorrect syntax for the default duration of the parameter \"" + paramName + "\"! Cause: " + pe.getMessage());
                                }
                            }
                            if (matcher.group(9).trim().length() > 0) {
                                try {
                                    ((DurationParamController)controller).setMinimum(((DurationParamController)controller).parseDuration(matcher.group(9).trim()));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new UWSException("Wrong numeric format for the minimum value of the parameter \"" + paramName + "\": \"" + matcher.group(9).trim() + "\"!");
                                }
                                catch (ParseException pe) {
                                    throw new UWSException("Incorrect syntax for the minimu duration of the parameter \"" + paramName + "\"! Cause: " + pe.getMessage());
                                }
                            }
                            if (matcher.group(10).trim().length() > 0) {
                                try {
                                    ((DurationParamController)controller).setMaximum(((DurationParamController)controller).parseDuration(matcher.group(10).trim()));
                                }
                                catch (NumberFormatException nfe) {
                                    throw new UWSException("Wrong numeric format for the maximum value of the parameter \"" + paramName + "\": \"" + matcher.group(10).trim() + "\"!");
                                }
                                catch (ParseException pe) {
                                    throw new UWSException("Incorrect syntax for the maximum duration of the parameter \"" + paramName + "\"! Cause: " + pe.getMessage());
                                }
                            }
                            jlParameters.put(paramName, controller);
                        }
                    }
                }
            }
            remaining = matcher.group(18);
            ++indParameter;
            modif = true;
        }
        if (jlParameters.size() > 0) {
            this.jobParams.put(jlName, jlParameters);
        }
    }

    @Override
    public JobThread createJobThread(UWSJob jobDescription) throws UWSException {
        if (jobDescription == null) {
            return null;
        }
        if (jobDescription.getJobList() == null) {
            throw new UWSException("Job without job list! Impossible to create a thread for the job \"" + jobDescription.getJobId() + "\".");
        }
        String jlName = jobDescription.getJobList().getName();
        if (jlName == null || this.jobThreads.get(jlName) == null) {
            throw new UWSException("No thread associated with jobs of the job list \"" + jlName + "\"! Impossible to create a thread for the job \"" + jobDescription.getJobId() + "\".");
        }
        Constructor<? extends JobThread> threadConstructor = this.jobThreads.get(jlName);
        try {
            return threadConstructor.newInstance(jobDescription);
        }
        catch (InstantiationException ie) {
            throw new UWSException("Impossible to create an instance of an abstract class: \"" + threadConstructor.getDeclaringClass().getName() + "\"!");
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null) {
                if (ite.getCause() instanceof UWSException) {
                    throw (UWSException)ite.getCause();
                }
                throw new UWSException(ite.getCause());
            }
            throw new UWSException(ite);
        }
        catch (Exception ex) {
            throw new UWSException(404, (Throwable)ex, "Impossible to create the thread " + threadConstructor.getDeclaringClass().getName() + " for the job \"" + jobDescription.getJobId() + "\"!");
        }
    }

    @Override
    public UWSJob createJob(HttpServletRequest request, JobOwner user) throws UWSException {
        String requestID = null;
        if (request != null && request.getAttribute("UWS_REQUEST_ID") != null && request.getAttribute("UWS_REQUEST_ID") instanceof String) {
            requestID = request.getAttribute("UWS_REQUEST_ID").toString();
        }
        UWSJob newJob = new UWSJob(user, this.createUWSParameters(request), requestID);
        Object jobDesc = request.getAttribute("UWS_JOB_DESCRIPTION");
        if (jobDesc != null && jobDesc instanceof JobInfo) {
            newJob.setJobInfo((JobInfo)jobDesc);
        }
        return newJob;
    }

    @Override
    public UWSJob createJob(String jobID, long creationTime, JobOwner owner, UWSParameters params, long quote, long startTime, long endTime, List<Result> results, ErrorSummary error) throws UWSException {
        return new UWSJob(jobID, creationTime, owner, params, quote, startTime, endTime, results, error);
    }

    @Override
    public UWSParameters createUWSParameters(Map<String, Object> params) throws UWSException {
        return new UWSParameters(params);
    }

    @Override
    public UWSParameters createUWSParameters(HttpServletRequest req) throws UWSException {
        UWSUrl url = new UWSUrl(req);
        if (url.getJobListName() != null && this.jobParams.get(url.getJobListName()) != null) {
            return new UWSParameters(req, this.jobParams.get(url.getJobListName()).keySet(), this.jobParams.get(url.getJobListName()));
        }
        return new UWSParameters(req);
    }

    @Override
    public RequestParser createRequestParser(UWSFileManager fileManager) throws UWSException {
        if (this.constructorRequestParser == null) {
            return new UWSRequestParser(fileManager);
        }
        try {
            return this.constructorRequestParser.newInstance(fileManager);
        }
        catch (InstantiationException ie) {
            throw new UWSException("Impossible to create an instance of an abstract class: \"" + this.constructorRequestParser.getDeclaringClass().getName() + "\"!");
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null) {
                if (ite.getCause() instanceof UWSException) {
                    throw (UWSException)ite.getCause();
                }
                throw new UWSException(ite.getCause());
            }
            throw new UWSException(ite);
        }
        catch (Exception ex) {
            throw new UWSException(404, (Throwable)ex, "Impossible to create the request parser " + this.constructorRequestParser.getDeclaringClass().getName() + "\"!");
        }
    }
}

