/*
 * Decompiled with CFR 0.152.
 */
package uws.job.manager;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import uws.job.ExecutionPhase;
import uws.job.UWSJob;
import uws.job.manager.DestructionManager;

public class DefaultDestructionManager
implements DestructionManager {
    private static final long serialVersionUID = 1L;
    protected final TreeSet<UWSJob> jobsToDestroy = new TreeSet<UWSJob>(new TimeComparator());
    protected transient Timer timDestruction = null;
    protected UWSJob currentJob = null;
    protected Date currentDate = null;

    @Override
    public final synchronized void stop() {
        if (this.timDestruction != null) {
            this.timDestruction.cancel();
        }
        this.timDestruction = null;
        this.currentDate = null;
        this.currentJob = null;
    }

    protected final void destroyJob(UWSJob job) {
        if (job != null && job.getJobList() != null && job.getPhase() != ExecutionPhase.ARCHIVED) {
            job.getJobList().destroyJob(job.getJobId());
        }
    }

    @Override
    public final boolean isRunning() {
        return this.currentDate != null;
    }

    @Override
    public final Date getNextDestruction() {
        return this.currentDate;
    }

    @Override
    public final String getNextJobToDestroy() {
        return this.currentJob == null ? null : this.currentJob.getJobId();
    }

    @Override
    public final int getNbJobsToDestroy() {
        return this.jobsToDestroy.size() + (this.isRunning() ? 1 : 0);
    }

    @Override
    public synchronized void refresh() {
        if (this.isRunning()) {
            if (this.currentDate.before(new Date())) {
                this.stop();
            } else if (this.currentJob.getPhase() == ExecutionPhase.ARCHIVED) {
                this.stop();
                this.jobsToDestroy.remove(this.currentJob);
            } else if (!this.currentJob.getDestructionTime().equals(this.currentDate) || !this.jobsToDestroy.isEmpty() && this.currentDate.after(this.jobsToDestroy.first().getDestructionTime())) {
                this.jobsToDestroy.add(this.currentJob);
                this.stop();
            }
        }
        if (!this.isRunning()) {
            this.currentJob = this.jobsToDestroy.pollFirst();
            while (!this.jobsToDestroy.isEmpty() && (this.currentJob == null || this.currentJob.getPhase() == ExecutionPhase.ARCHIVED || this.currentJob.getDestructionTime() == null || this.currentJob.getDestructionTime().before(new Date()))) {
                if (this.currentJob.getPhase() == ExecutionPhase.ARCHIVED) {
                    this.jobsToDestroy.remove(this.currentJob);
                } else if (this.currentJob.getDestructionTime() != null) {
                    this.destroyJob(this.currentJob);
                }
                this.currentJob = this.jobsToDestroy.pollFirst();
            }
            if (this.currentJob != null) {
                this.timDestruction = new Timer();
                this.currentDate = this.currentJob.getDestructionTime();
                this.timDestruction.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        DefaultDestructionManager.this.destroyJob(DefaultDestructionManager.this.currentJob);
                    }
                }, this.currentDate);
            }
        }
    }

    @Override
    public synchronized void update(UWSJob job) {
        if (job != null && job.getJobList() != null && job.getDestructionTime() != null && job.getPhase() != ExecutionPhase.ARCHIVED) {
            if (job.getDestructionTime().before(new Date())) {
                this.destroyJob(job);
            } else if (!this.jobsToDestroy.contains(job)) {
                this.jobsToDestroy.add(job);
                this.refresh();
            }
        }
    }

    @Override
    public synchronized void remove(UWSJob job) {
        if (job == null) {
            return;
        }
        if (this.isRunning() && this.currentJob != null && this.currentJob.equals(job)) {
            this.stop();
            this.refresh();
        } else {
            this.jobsToDestroy.remove(job);
        }
    }

    protected static class TimeComparator
    implements Serializable,
    Comparator<UWSJob> {
        private static final long serialVersionUID = 1L;

        protected TimeComparator() {
        }

        @Override
        public int compare(UWSJob job1, UWSJob job2) {
            if (job1 == null && job2 == null) {
                return 0;
            }
            Date date1 = job1.getDestructionTime();
            Date date2 = job2.getDestructionTime();
            if (date1 == null && date2 == null) {
                return 0;
            }
            if (date1 != null && (date2 == null || date1.before(date2))) {
                return -1;
            }
            if (date2 != null && (date1 == null || date1.after(date2))) {
                return 1;
            }
            return 0;
        }
    }
}

