/*
 * Decompiled with CFR 0.152.
 */
package uws.service.backup;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.JSONWriter;
import org.json.Json4Uws;
import uws.ISO8601Format;
import uws.UWSException;
import uws.UWSToolBox;
import uws.job.ErrorSummary;
import uws.job.ErrorType;
import uws.job.JobList;
import uws.job.Result;
import uws.job.UWSJob;
import uws.job.jobInfo.JobInfo;
import uws.job.parameters.UWSParameters;
import uws.job.user.JobOwner;
import uws.service.UWS;
import uws.service.backup.UWSBackupManager;
import uws.service.file.UWSFileManager;
import uws.service.log.UWSLog;
import uws.service.request.UploadFile;

public class DefaultUWSBackupManager
implements UWSBackupManager {
    public static final long AT_USER_ACTION = 0L;
    public static final long MANUAL = -1L;
    public static final long DEFAULT_FREQUENCY = 60000L;
    protected Date lastRestoration = null;
    protected Date lastBackup = null;
    protected final UWS uws;
    protected boolean enabled = true;
    protected final boolean byUser;
    protected long backupFreq = 0L;
    protected Timer timAutoBackup = null;

    public DefaultUWSBackupManager(UWS uws) {
        this(uws, 60000L);
    }

    public DefaultUWSBackupManager(UWS uws, long frequency) {
        this.uws = uws;
        this.byUser = false;
        long l = this.backupFreq = frequency <= 0L ? -1L : frequency;
        if (this.backupFreq > 0L) {
            this.timAutoBackup = new Timer();
            this.timAutoBackup.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    DefaultUWSBackupManager.this.saveAll();
                }
            }, this.backupFreq, this.backupFreq);
        }
    }

    public DefaultUWSBackupManager(UWS uws, boolean byUser) throws UWSException {
        this(uws, byUser, byUser ? 0L : 60000L);
    }

    public DefaultUWSBackupManager(UWS uws, boolean byUser, long frequency) throws UWSException {
        this.uws = uws;
        this.byUser = byUser;
        this.backupFreq = frequency;
        if (byUser && uws.getUserIdentifier() == null) {
            throw new UWSException(500, "Impossible to save/restore a UWS by user if the user identification is disabled (no UserIdentifier is set to the UWS)!");
        }
        if (this.backupFreq == 0L && !byUser) {
            this.backupFreq = -1L;
        } else if (this.backupFreq > 0L) {
            this.timAutoBackup = new Timer();
            this.timAutoBackup.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    DefaultUWSBackupManager.this.saveAll();
                }
            }, this.backupFreq, this.backupFreq);
        } else if (this.backupFreq < 0L) {
            this.backupFreq = -1L;
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.backupFreq > 0L) {
            if (this.enabled) {
                if (this.timAutoBackup == null) {
                    this.timAutoBackup = new Timer();
                    this.timAutoBackup.scheduleAtFixedRate(new TimerTask(){

                        @Override
                        public void run() {
                            DefaultUWSBackupManager.this.saveAll();
                        }
                    }, this.backupFreq, this.backupFreq);
                }
            } else if (this.timAutoBackup != null) {
                this.timAutoBackup.cancel();
                this.timAutoBackup = null;
            }
        }
    }

    public final long getBackupFreq() {
        return this.backupFreq;
    }

    public final void setBackupFreq(long freq) {
        if (freq < 0L) {
            freq = -1L;
        } else if (freq == 0L && !this.byUser) {
            return;
        }
        this.backupFreq = freq;
        if (this.timAutoBackup != null) {
            this.timAutoBackup.cancel();
            this.timAutoBackup = null;
        }
        if (this.enabled && this.backupFreq > 0L) {
            this.timAutoBackup = new Timer();
            this.timAutoBackup.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    DefaultUWSBackupManager.this.saveAll();
                }
            }, 0L, this.backupFreq);
        }
    }

    public final Date getLastRestoration() {
        return this.lastRestoration;
    }

    public final Date getLastBackup() {
        return this.lastBackup;
    }

    public UWSLog getLogger() {
        if (this.uws.getLogger() != null) {
            return this.uws.getLogger();
        }
        return UWSToolBox.getDefaultLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] saveAll() {
        if (!this.enabled) {
            return null;
        }
        int nbSavedJobs = 0;
        int nbSavedOwners = 0;
        int nbJobs = 0;
        int nbOwners = 0;
        HashMap<String, JobOwner> users = new HashMap<String, JobOwner>();
        for (Object jl : this.uws) {
            Iterator<JobOwner> it = ((JobList)jl).getUsers();
            while (it.hasNext()) {
                JobOwner owner = it.next();
                users.put(owner.getID(), owner);
            }
        }
        if (this.byUser) {
            for (JobOwner user : users.values()) {
                ++nbOwners;
                int[] saveReport = this.saveOwner(user, true);
                if (saveReport == null || saveReport.length != 2) continue;
                nbSavedJobs += saveReport[0];
                nbJobs += saveReport[1];
                ++nbSavedOwners;
            }
        } else {
            UWSFileManager fileManager = this.uws.getFileManager();
            try (PrintWriter writer = null;){
                writer = new PrintWriter(fileManager.getBackupOutput());
                JSONWriter out = new JSONWriter(writer);
                out.object();
                out.key("date").value(new Date().toString());
                out.key("users").array();
                for (JobOwner user : users.values()) {
                    ++nbOwners;
                    try {
                        out.value(this.getJSONUser(user));
                        ++nbSavedOwners;
                    }
                    catch (JSONException je) {
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, user, "BACKUP", "Unexpected JSON error while saving the user '" + user.getID() + "'!", je);
                    }
                }
                out.endArray();
                writer.flush();
                out.key("jobs").array();
                for (JobList jl : this.uws) {
                    for (UWSJob job : jl) {
                        ++nbJobs;
                        try {
                            out.value(this.getJSONJob(job, jl.getName()));
                            ++nbSavedJobs;
                            writer.flush();
                        }
                        catch (UWSException ue) {
                            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, job, "BACKUP", "Unexpected UWS error while saving the job '" + job.getJobId() + "'!", ue);
                        }
                        catch (JSONException je) {
                            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, job, "BACKUP", "Unexpected JSON error while saving the job '" + job.getJobId() + "'!", je);
                        }
                    }
                }
                out.endArray();
                out.endObject();
            }
        }
        int[] report = new int[]{nbSavedJobs, nbJobs, nbSavedOwners, nbOwners};
        this.getLogger().logUWS(UWSLog.LogLevel.INFO, report, "BACKUPED", "UWS Service \"" + this.uws.getName() + "\" backuped!", null);
        this.lastBackup = new Date();
        return report;
    }

    @Override
    public int[] saveOwner(JobOwner user) {
        if (!this.enabled) {
            return null;
        }
        return this.saveOwner(user, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] saveOwner(JobOwner user, boolean fromSaveAll) {
        if (!this.enabled) {
            return null;
        }
        if (!fromSaveAll && this.backupFreq != 0L) {
            return new int[]{-1, -1};
        }
        UWSFileManager fileManager = this.uws.getFileManager();
        int[] saveReport = new int[]{0, 0};
        try (PrintWriter writer = null;){
            writer = new PrintWriter(fileManager.getBackupOutput(user));
            JSONWriter out = new JSONWriter(writer);
            out.object();
            out.key("date").value(ISO8601Format.format(new Date()));
            out.key("user").value(this.getJSONUser(user));
            writer.flush();
            out.key("jobs").array();
            for (JobList jl : this.uws) {
                Iterator<UWSJob> it = jl.getJobs(user);
                while (it.hasNext()) {
                    saveReport[1] = saveReport[1] + 1;
                    try {
                        out.value(this.getJSONJob(it.next(), jl.getName()));
                        saveReport[0] = saveReport[0] + 1;
                        writer.flush();
                    }
                    catch (JSONException je) {
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, null, "BACKUP", "Unexpected JSON error while saving the " + saveReport[1] + "-th job of the job list '" + jl.getName() + "' owned by the user '" + user.getID() + "'!", je);
                    }
                    catch (UWSException ue) {
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, null, "BACKUP", "Unexpected UWS error while saving the " + saveReport[1] + "-th job of the job list '" + jl.getName() + "' owned by the user '" + user.getID() + "'!", ue);
                    }
                }
            }
            out.endArray();
            out.endObject();
            this.getLogger().logUWS(UWSLog.LogLevel.INFO, saveReport, "BACKUPED", "UWS backuped!", null);
            this.lastBackup = new Date();
            Object object = saveReport;
            return object;
        }
        return null;
    }

    protected JSONObject getJSONUser(JobOwner user) throws JSONException {
        JSONObject jsonUser = new JSONObject();
        jsonUser.put("id", user.getID());
        jsonUser.put("pseudo", user.getPseudo());
        if (user.getDataToSave() != null) {
            for (Map.Entry<String, Object> userData : user.getDataToSave().entrySet()) {
                jsonUser.put(userData.getKey(), userData.getValue());
            }
        }
        return jsonUser;
    }

    protected JSONObject getJSONJob(UWSJob job, String jlName) throws UWSException, JSONException {
        JSONObject jsonJob = Json4Uws.getJson(job);
        jsonJob.put("quote", job.getQuote());
        JSONArray uploads = new JSONArray();
        JSONObject params = new JSONObject();
        for (String name : job.getAdditionalParameters()) {
            Object val = job.getAdditionalParameterValue(name);
            if (val != null && val.getClass().isArray()) {
                JSONArray array = new JSONArray();
                for (Object o : (Object[])val) {
                    if (o == null) continue;
                    array.put(o.toString());
                }
                params.put(name, array);
                continue;
            }
            if (val != null && val instanceof UploadFile) {
                uploads.put(this.getUploadJson((UploadFile)val));
                continue;
            }
            if (val == null) continue;
            params.put(name, val);
        }
        jsonJob.put("parameters", params);
        jsonJob.put("uwsUploads", uploads);
        jsonJob.put("owner", job != null && job.getOwner() != null ? job.getOwner().getID() : null);
        jsonJob.put("jobListName", jlName);
        if (job.getJobInfo() != null) {
            jsonJob.put("jobInfo", this.getJSONJobInfo(job.getJobInfo()));
        } else {
            jsonJob.remove("jobInfo");
        }
        return jsonJob;
    }

    protected Object getJSONJobInfo(JobInfo jobInfo) throws UWSException, JSONException {
        ByteArrayOutputStream bArray = null;
        ObjectOutputStream oOutput = null;
        try {
            bArray = new ByteArrayOutputStream();
            oOutput = new ObjectOutputStream(bArray);
            oOutput.writeObject(jobInfo);
            oOutput.flush();
            String string = this.toBase64(bArray.toByteArray());
            return string;
        }
        catch (IOException ioe) {
            throw new UWSException(500, (Throwable)ioe, "Unexpected error while serializing the given JobInfo!");
        }
        finally {
            if (oOutput != null) {
                try {
                    oOutput.close();
                }
                catch (IOException iOException) {}
            }
            if (bArray != null) {
                try {
                    bArray.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected JobInfo restoreJobInfo(Object jsonValue) throws UWSException, JSONException {
        ObjectInputStream oInput = null;
        try {
            byte[] bArray = this.fromBase64((String)jsonValue);
            oInput = new ObjectInputStream(new ByteArrayInputStream(bArray));
            JobInfo jobInfo = (JobInfo)oInput.readObject();
            return jobInfo;
        }
        catch (Exception ex) {
            throw new UWSException(500, (Throwable)ex, "Unexpected error while restoring a JobInfo!");
        }
        finally {
            if (oInput != null) {
                try {
                    oInput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected final String toBase64(byte[] bytes) {
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    protected final byte[] fromBase64(String base64Str) {
        return DatatypeConverter.parseBase64Binary((String)base64Str);
    }

    protected JSONObject getUploadJson(UploadFile upl) throws JSONException {
        if (upl == null) {
            return null;
        }
        JSONObject o = new JSONObject();
        o.put("paramName", upl.paramName);
        o.put("fileName", upl.fileName);
        o.put("location", upl.getLocation());
        o.put("mime", upl.mimeType);
        o.put("length", upl.length);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] restoreAll() {
        SingleInputIterator itInput;
        for (JobList jl : this.uws) {
            jl.clear();
        }
        int nbRestoredJobs = 0;
        int nbRestoredUsers = 0;
        int nbJobs = 0;
        int nbUsers = 0;
        boolean userIdentificationEnabled = this.uws.getUserIdentifier() != null;
        UWSFileManager fileManager = this.uws.getFileManager();
        if (this.byUser) {
            if (!userIdentificationEnabled) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, null, "RESTORATION", "Impossible to restore a UWS by user if the user identification is disabled (that's to say, the UWS has no UserIdentifier)!", null);
                return null;
            }
            itInput = fileManager.getAllUserBackupInputs();
        } else {
            try {
                itInput = new SingleInputIterator(fileManager.getBackupInput());
            }
            catch (IOException ioe) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, null, "RESTORATION", "Restoration of the UWS " + this.uws.getName() + " failed because an unexpected IO error has occured.", ioe);
                return null;
            }
        }
        while (itInput.hasNext()) {
            int[] nArray;
            InputStream inputStream = (InputStream)itInput.next();
            if (inputStream == null) continue;
            JSONTokener in = new JSONTokener(new InputStreamReader(inputStream));
            HashMap<String, JobOwner> users = new HashMap<String, JobOwner>();
            JSONObject object = null;
            try {
                String key;
                JSONObjectReader itKeys = new JSONObjectReader(in, this.getLogger());
                while (itKeys.hasNext() && (key = itKeys.next()) != null) {
                    JSONArrayReader it;
                    if (key.equalsIgnoreCase("date")) {
                        itKeys.getValue();
                        continue;
                    }
                    if (key.equalsIgnoreCase("user")) {
                        ++nbUsers;
                        try {
                            JobOwner user;
                            object = itKeys.getJSONObject();
                            if (object == null) {
                                --nbUsers;
                                continue;
                            }
                            if (!userIdentificationEnabled || (user = this.getUser(object)) == null) continue;
                            users.put(user.getID(), user);
                            ++nbRestoredUsers;
                        }
                        catch (UWSException ue) {
                            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, object, "RESTORATION", "A job owner can not be restored!", ue);
                        }
                        continue;
                    }
                    if (key.equalsIgnoreCase("users")) {
                        it = itKeys.getArrayReader();
                        while (it.hasNext()) {
                            ++nbUsers;
                            try {
                                JobOwner user;
                                object = (JSONObject)it.next();
                                if (object == null) {
                                    --nbUsers;
                                    continue;
                                }
                                if (!userIdentificationEnabled || (user = this.getUser(object)) == null) continue;
                                users.put(user.getID(), user);
                                ++nbRestoredUsers;
                            }
                            catch (UWSException ue) {
                                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, object, "RESTORATION", "The " + nbUsers + "-th user can not be restored!", ue);
                            }
                        }
                        continue;
                    }
                    if (key.equalsIgnoreCase("jobs")) {
                        it = itKeys.getArrayReader();
                        while (it.hasNext()) {
                            ++nbJobs;
                            try {
                                object = (JSONObject)it.next();
                                if (object == null) {
                                    --nbJobs;
                                    continue;
                                }
                                if (!this.restoreJob(object, users)) continue;
                                ++nbRestoredJobs;
                            }
                            catch (UWSException ue) {
                                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, object, "RESTORATION", "The " + nbJobs + "-th job can not be restored!", ue);
                            }
                        }
                        continue;
                    }
                    this.getLogger().logUWS(UWSLog.LogLevel.WARNING, null, "RESTORATION", "Key '" + key + "' ignored because unknown! The UWS may be not completely restored.", null);
                }
            }
            catch (JSONException je) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, null, "RESTORATION", "Incorrect JSON format for a UWS backup file!", je);
                nArray = null;
                return nArray;
            }
            catch (Exception e) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, null, "RESTORATION", "Unexpected error while restoring the UWS!", e);
                nArray = null;
                return nArray;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    this.getLogger().logUWS(UWSLog.LogLevel.ERROR, null, "RESTORATION", "Can not close the input stream opened on a user backup file!", ioe);
                }
                this.lastRestoration = new Date();
            }
        }
        if (!userIdentificationEnabled && nbUsers > 0) {
            this.getLogger().logUWS(UWSLog.LogLevel.WARNING, null, "RESTORATION", nbUsers + " job owners have not been restored because the user identification is disabled in this UWS! => Jobs of these users have not been restored.", null);
        }
        int[] report = new int[]{nbRestoredJobs, nbJobs, nbRestoredUsers, nbUsers};
        this.getLogger().logUWS(UWSLog.LogLevel.INFO, report, "RESTORED", "UWS restored!", null);
        return report;
    }

    protected JobOwner getUser(JSONObject json) throws UWSException {
        if (json == null || json.length() == 0) {
            return null;
        }
        String ID = null;
        String pseudo = null;
        String[] keys = JSONObject.getNames(json);
        HashMap<String, Object> userData = new HashMap<String, Object>(keys.length - 2);
        for (String key : keys) {
            try {
                if (key.equalsIgnoreCase("id")) {
                    ID = json.getString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("pseudo")) {
                    pseudo = json.getString(key);
                    continue;
                }
                userData.put(key, json.get(key));
            }
            catch (JSONException je) {
                this.getLogger().logUWS(UWSLog.LogLevel.WARNING, null, "RESTORATION", "Incorrect JSON format for the serialization of the user \"" + ID + "\"! The restoration of this job may be incomplete.", je);
            }
        }
        if (ID == null || ID.trim().isEmpty()) {
            throw new UWSException(500, null, "Impossible to restore a user from the backup file(s): no ID has been found!");
        }
        return this.uws.getUserIdentifier().restoreUser(ID, pseudo, userData);
    }

    protected boolean restoreJob(JSONObject json, Map<String, JobOwner> users) throws UWSException {
        String[] keys;
        if (json == null || json.length() == 0) {
            return false;
        }
        String jobListName = null;
        String jobId = null;
        String ownerID = null;
        long quote = 0L;
        long startTime = -1L;
        long endTime = -1L;
        long creationTime = -1L;
        HashMap<String, Object> inputParams = new HashMap<String, Object>(10);
        List<Result> results = null;
        ErrorSummary error = null;
        JSONArray uploads = null;
        JobInfo jobInfo = null;
        for (String key : keys = JSONObject.getNames(json)) {
            try {
                String tmp;
                if (key.equalsIgnoreCase("jobListName")) {
                    jobListName = json.getString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("jobId")) {
                    jobId = json.getString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("phase")) continue;
                if (key.equalsIgnoreCase("owner")) {
                    ownerID = json.getString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("runId")) {
                    String runId = json.getString(key);
                    inputParams.put("runId", runId);
                    continue;
                }
                if (key.equalsIgnoreCase("quote")) {
                    quote = json.getLong(key);
                    continue;
                }
                if (key.equalsIgnoreCase("creationTime")) {
                    tmp = json.getString(key);
                    try {
                        Date d = ISO8601Format.parseToDate(tmp);
                        creationTime = d.getTime();
                    }
                    catch (ParseException pe) {
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Incorrect date format for the '" + key + "' parameter!", pe);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("executionDuration")) {
                    long duration = json.getLong(key);
                    inputParams.put("executionDuration", duration);
                    continue;
                }
                if (key.equalsIgnoreCase("destruction")) {
                    try {
                        tmp = json.getString(key);
                        inputParams.put("destruction", ISO8601Format.parseToDate(tmp));
                    }
                    catch (ParseException pe) {
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Incorrect date format for the '" + key + "' parameter!", pe);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("startTime")) {
                    tmp = json.getString(key);
                    try {
                        Date d = ISO8601Format.parseToDate(tmp);
                        startTime = d.getTime();
                    }
                    catch (ParseException pe) {
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Incorrect date format for the '" + key + "' parameter!", pe);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("endTime")) {
                    tmp = json.getString(key);
                    try {
                        Date d = ISO8601Format.parseToDate(tmp);
                        endTime = d.getTime();
                    }
                    catch (ParseException pe) {
                        this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Incorrect date format for the '" + key + "' parameter!", pe);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("parameters")) {
                    inputParams.put("parameters", this.getParameters(json.getJSONObject(key)));
                    continue;
                }
                if (key.equalsIgnoreCase("uwsUploads")) {
                    uploads = json.getJSONArray(key);
                    continue;
                }
                if (key.equalsIgnoreCase("results")) {
                    results = this.getResults(json.getJSONArray(key));
                    continue;
                }
                if (key.equalsIgnoreCase("error")) {
                    error = this.getError(json.getJSONObject(key));
                    continue;
                }
                if (key.equalsIgnoreCase("jobInfo")) {
                    jobInfo = this.restoreJobInfo(json.get(key));
                    continue;
                }
                if (key.equalsIgnoreCase("version")) continue;
                this.getLogger().logUWS(UWSLog.LogLevel.WARNING, json, "RESTORATION", "The job attribute '" + key + "' has been ignored because unknown! A job may be not completely restored!", null);
            }
            catch (JSONException je) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Incorrect JSON format for a job serialization (attribute: \"" + key + "\")!", je);
            }
        }
        if (uploads != null) {
            Map params = (Map)inputParams.get("parameters");
            try {
                for (int i = 0; i < uploads.length(); ++i) {
                    UploadFile upl = this.getUploadFile(uploads.getJSONObject(i));
                    if (upl == null) continue;
                    params.put(upl.paramName, upl);
                }
            }
            catch (JSONException je) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Incorrect JSON format for the serialization of the job \"" + jobId + "\" (attribute: \"uwsUploads\")!", je);
            }
        }
        if (jobListName == null || jobListName.isEmpty()) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Missing job list name! => Can not restore the job " + jobId + "!", null);
        } else if (this.uws.getJobList(jobListName) == null) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "No job list named " + jobListName + "! => Can not restore the job " + jobId + "!", null);
        } else if (jobId == null || jobId.isEmpty()) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Missing job ID! => Can not restore a job!", null);
        } else {
            UWSParameters uwsParams;
            JobOwner owner = users.get(ownerID);
            if (ownerID != null && !ownerID.isEmpty() && owner == null) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Unknown job owner: " + ownerID + "! => Can not restore the job " + jobId + "!", null);
                return false;
            }
            try {
                uwsParams = this.uws.getFactory().createUWSParameters(inputParams);
            }
            catch (UWSException ue) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, json, "RESTORATION", "Error with at least one of the UWS parameters to restore!", ue);
                return false;
            }
            UWSJob job = this.uws.getFactory().createJob(jobId, creationTime, owner, uwsParams, quote, startTime, endTime, results, error);
            if (jobInfo != null) {
                job.setJobInfo(jobInfo);
            }
            this.restoreOtherJobParams(json, job);
            return this.uws.getJobList(jobListName).addNewJob(job) != null;
        }
        return false;
    }

    protected void restoreOtherJobParams(JSONObject json, UWSJob job) throws UWSException {
    }

    protected Map<String, Object> getParameters(JSONObject obj) {
        String[] names;
        if (obj == null || obj.length() == 0) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(obj.length());
        for (String n : names = JSONObject.getNames(obj)) {
            try {
                params.put(n, obj.get(n));
            }
            catch (JSONException je) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, obj, "RESTORATION", "Incorrect JSON format for the serialization of the parameter '" + n + "'!", je);
            }
        }
        return params;
    }

    protected UploadFile getUploadFile(JSONObject obj) {
        try {
            UploadFile upl = new UploadFile(obj.getString("paramName"), obj.has("fileName") ? obj.getString("fileName") : null, obj.getString("location"), this.uws.getFileManager());
            if (obj.has("mime")) {
                upl.mimeType = obj.getString("mime");
            }
            try {
                if (obj.has("length")) {
                    upl.length = Long.parseLong(obj.getString("length"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return upl;
        }
        catch (JSONException je) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, obj, "RESTORATION", "Incorrect JSON format for the serialization of an uploaded file!", je);
            return null;
        }
    }

    protected List<Result> getResults(JSONArray array) throws UWSException {
        if (array == null || array.length() == 0) {
            return null;
        }
        ArrayList<Result> results = new ArrayList<Result>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            try {
                Result r = this.getResult(array.getJSONObject(i));
                if (r == null) continue;
                results.add(r);
                continue;
            }
            catch (JSONException je) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, array, "RESTORATION", "Incorrect JSON format for the serialization of the " + (i + 1) + "-th result!", je);
            }
        }
        return results;
    }

    protected Result getResult(JSONObject obj) throws JSONException, UWSException {
        String[] names;
        if (obj == null || obj.length() == 0) {
            return null;
        }
        String id = null;
        String type = null;
        String href = null;
        String mime = null;
        boolean redirection = false;
        long size = -1L;
        for (String n : names = JSONObject.getNames(obj)) {
            if (n.equalsIgnoreCase("id")) {
                id = obj.getString(n);
                continue;
            }
            if (n.equalsIgnoreCase("type")) {
                type = obj.getString(n);
                continue;
            }
            if (n.equalsIgnoreCase("href")) {
                href = obj.getString(n);
                continue;
            }
            if (n.equalsIgnoreCase("mime-type")) {
                mime = obj.getString(n);
                continue;
            }
            if (n.equalsIgnoreCase("redirection")) {
                redirection = obj.getBoolean(n);
                continue;
            }
            if (n.equalsIgnoreCase("size")) {
                size = obj.getLong(n);
                continue;
            }
            this.getLogger().logUWS(UWSLog.LogLevel.WARNING, obj, "RESTORATION", "The result parameter '" + n + "' has been ignored because unknown! A result may be not completely restored!", null);
        }
        if (id == null) {
            this.getLogger().logUWS(UWSLog.LogLevel.ERROR, obj, "RESTORATION", "Missing result ID! => A result can not be restored!", null);
            return null;
        }
        Result r = new Result(id, type, href, redirection);
        r.setMimeType(mime);
        r.setSize(size);
        return r;
    }

    protected ErrorSummary getError(JSONObject obj) throws UWSException {
        String[] names;
        if (obj == null || obj.length() == 0) {
            return null;
        }
        String type = null;
        String message = null;
        String details = null;
        for (String n : names = JSONObject.getNames(obj)) {
            try {
                if (n.equalsIgnoreCase("type")) {
                    type = obj.getString(n);
                    continue;
                }
                if (n.equalsIgnoreCase("detailsRef")) {
                    details = obj.getString(n);
                    continue;
                }
                if (n.equalsIgnoreCase("hasDetail")) continue;
                if (n.equalsIgnoreCase("message")) {
                    message = obj.getString(n);
                    continue;
                }
                this.getLogger().logUWS(UWSLog.LogLevel.WARNING, obj, "RESTORATION", "The error attribute '" + n + "' has been ignored because unknown! => An error summary may be not completely restored!", null);
            }
            catch (JSONException je) {
                this.getLogger().logUWS(UWSLog.LogLevel.ERROR, obj, "RESTORATION", "Incorrect JSON format for an error serialization!", je);
            }
        }
        if (message != null) {
            return new ErrorSummary(message, ErrorType.valueOf(type.toUpperCase()), details);
        }
        return null;
    }

    protected static final class SingleInputIterator
    implements Iterator<InputStream> {
        private InputStream input;

        public SingleInputIterator(InputStream input) {
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            return this.input != null;
        }

        @Override
        public InputStream next() throws NoSuchElementException {
            if (this.input == null) {
                throw new NoSuchElementException();
            }
            InputStream in = this.input;
            this.input = null;
            return in;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class JSONArrayReader
    implements Iterator<JSONObject> {
        private final UWSLog logger;
        private final JSONTokener input;
        private final char closeToken;
        private boolean endReached = false;
        private JSONObject nextObj = null;

        public JSONArrayReader(JSONTokener input, UWSLog log) throws JSONException {
            this.input = input;
            this.logger = log;
            char c = input.nextClean();
            switch (c) {
                case '[': {
                    this.closeToken = (char)93;
                    break;
                }
                case '(': {
                    this.closeToken = (char)41;
                    break;
                }
                default: {
                    this.endReached = true;
                    throw input.syntaxError("A JSONArray text must start with '['");
                }
            }
            this.readNext();
        }

        protected void readNext() throws JSONException {
            this.nextObj = null;
            block4: while (this.nextObj == null && !this.endReached) {
                char c = this.input.nextClean();
                if (c != ',' && c != ';' && c != ']' && c != ')') {
                    this.input.back();
                    this.nextObj = (JSONObject)this.input.nextValue();
                    c = this.input.nextClean();
                }
                switch (c) {
                    case ',': 
                    case ';': {
                        if (this.input.nextClean() == ']') {
                            this.endReached = true;
                            return;
                        }
                        this.input.back();
                        continue block4;
                    }
                    case ')': 
                    case ']': {
                        this.endReached = true;
                        if (this.closeToken != c) {
                            throw this.input.syntaxError("Expected a '" + new Character(this.closeToken) + "'");
                        }
                        return;
                    }
                }
                this.endReached = true;
                throw this.input.syntaxError("Expected a ',' or ']'");
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextObj != null;
        }

        @Override
        public JSONObject next() throws NoSuchElementException {
            if (this.nextObj == null && this.endReached) {
                throw new NoSuchElementException();
            }
            JSONObject obj = this.nextObj;
            try {
                this.readNext();
            }
            catch (JSONException je) {
                this.logger.logUWS(UWSLog.LogLevel.ERROR, null, "RESTORATION", "Incorrect JSON format in an Array!", je);
                this.endReached = true;
                this.nextObj = null;
            }
            return obj;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class JSONObjectReader
    implements Iterator<String> {
        private final UWSLog logger;
        private final JSONTokener input;
        private String nextKey = null;
        private boolean valueGot = false;
        private boolean endReached = false;

        public JSONObjectReader(JSONTokener input, UWSLog log) throws JSONException {
            this.input = input;
            this.logger = log;
            if (input.nextClean() != '{') {
                throw input.syntaxError("A JSONObject text must begin with '{'");
            }
            if (input.nextClean() == '}') {
                this.endReached = true;
            } else {
                input.back();
            }
        }

        private void readNext() throws JSONException {
            if (this.nextKey != null) {
                this.nextKey = null;
                if (!this.prepareNextPair()) {
                    this.nextKey = null;
                    return;
                }
            }
            char c = this.input.nextClean();
            switch (c) {
                case '\u0000': {
                    throw this.input.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    this.endReached = true;
                    return;
                }
            }
            this.input.back();
            this.nextKey = this.input.nextValue().toString();
            c = this.input.nextClean();
            if (c == '=') {
                if (this.input.next() != '>') {
                    this.input.back();
                }
            } else if (c != ':') {
                throw this.input.syntaxError("Expected a ':' after a key");
            }
        }

        private boolean prepareNextPair() throws JSONException {
            if (!this.valueGot) {
                this.skipValue();
            }
            switch (this.input.nextClean()) {
                case ',': 
                case ';': {
                    if (this.input.nextClean() == '}') {
                        this.endReached = true;
                        return false;
                    }
                    this.input.back();
                    break;
                }
                case '}': {
                    this.endReached = true;
                    return false;
                }
                default: {
                    throw this.input.syntaxError("Expected a ',' or '}'");
                }
            }
            return true;
        }

        private void skipValue() throws JSONException {
            this.valueGot = true;
            this.input.nextValue();
        }

        public JSONObject getJSONObject() throws JSONException {
            this.valueGot = true;
            return new JSONObject(this.input);
        }

        public JSONArray getJSONArray() throws JSONException {
            this.valueGot = true;
            return new JSONArray(this.input);
        }

        public String getString() throws JSONException {
            this.valueGot = true;
            return this.input.nextValue().toString();
        }

        public Object getValue() throws JSONException {
            this.valueGot = true;
            return this.input.nextValue();
        }

        public JSONArrayReader getArrayReader() throws JSONException {
            this.valueGot = true;
            return new JSONArrayReader(this.input, this.logger);
        }

        public JSONObjectReader getObjectReader() throws JSONException {
            this.valueGot = true;
            return new JSONObjectReader(this.input, this.logger);
        }

        @Override
        public boolean hasNext() {
            return !this.endReached;
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.endReached) {
                throw new NoSuchElementException();
            }
            try {
                this.readNext();
                return this.nextKey;
            }
            catch (JSONException je) {
                this.logger.logUWS(UWSLog.LogLevel.ERROR, null, "RESTORATION", "Incorrect JSON format in an object!", je);
                this.endReached = true;
                return null;
            }
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

