/*
 * Decompiled with CFR 0.152.
 */
package uws.service.request;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import uws.UWSException;
import uws.service.file.UWSFileManager;
import uws.service.request.RequestParser;
import uws.service.request.UploadFile;

public class MultipartParser
implements RequestParser {
    public static final String EXPECTED_CONTENT_TYPE = "multipart/form-data";
    public static final int DEFAULT_FILE_SIZE_LIMIT = -1;
    public static final int DEFAULT_SIZE_LIMIT = -1;
    protected static final int SIZE_BEFORE_DISK_STORAGE = 10240;
    @Deprecated
    public static int SIZE_LIMIT = -1;
    public final boolean allowUpload;
    protected final UWSFileManager fileManager;
    protected final ServletFileUpload fileUpload;

    public MultipartParser() {
        this(false, null);
    }

    public MultipartParser(UWSFileManager fileManager) {
        this(true, fileManager);
    }

    protected MultipartParser(boolean uploadEnabled, UWSFileManager fileManager) {
        this(uploadEnabled, fileManager, -1L, -1L);
    }

    protected MultipartParser(boolean uploadEnabled, UWSFileManager fileManager, long maxFileSize, long maxRequestSize) {
        if (uploadEnabled && fileManager == null) {
            throw new NullPointerException("Missing file manager although the upload capability is enabled => can not create a MultipartParser!");
        }
        this.allowUpload = uploadEnabled;
        this.fileManager = fileManager;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(fileManager.getTmpDirectory());
        factory.setSizeThreshold(10240);
        this.fileUpload = new ServletFileUpload(factory);
        this.fileUpload.setFileSizeMax(maxFileSize);
        this.fileUpload.setSizeMax(maxRequestSize);
    }

    public final long getMaxFileSize() {
        return this.fileUpload.getFileSizeMax();
    }

    public void setMaxFileSize(long maxFileSize) {
        this.fileUpload.setFileSizeMax(maxFileSize);
    }

    public final long getMaxRequestSize() {
        return this.fileUpload.getSizeMax();
    }

    public void setMaxRequestSize(long maxRequestSize) {
        this.fileUpload.setSizeMax(maxRequestSize < 0L ? -1L : maxRequestSize);
    }

    @Override
    public final Map<String, Object> parse(HttpServletRequest request) throws UWSException {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        try {
            List<FileItem> fileItems = this.fileUpload.parseRequest(request);
            for (FileItem item : fileItems) {
                String name = item.getFieldName();
                InputStream stream = item.getInputStream();
                if (item.isFormField()) {
                    this.consumeParameter(name, Streams.asString(stream), parameters);
                } else {
                    if (!this.allowUpload) {
                        throw new UWSException(400, "Uploads are not allowed by this service!");
                    }
                    File file = this.getFileFromParam(request, this.fileManager.getTmpDirectory().getPath(), FilenameUtils.getName(item.getName()));
                    FileUtils.copyInputStreamToFile(stream, file);
                    UploadFile lob = new UploadFile(name, FilenameUtils.getName(item.getName()), file.toURI().toString(), this.fileManager);
                    lob.mimeType = item.getContentType();
                    lob.length = file.length();
                    this.consumeParameter(name, lob, parameters);
                }
                item.delete();
            }
        }
        catch (FileUploadException fue) {
            throw new UWSException(400, (Throwable)fue, "Incorrect HTTP request: " + fue.getMessage() + " (server limits: each file/parameter <= " + (this.fileUpload.getFileSizeMax() <= 0L ? "unlimited" : this.fileUpload.getFileSizeMax() + " bytes") + " and the whole request <= " + (this.fileUpload.getSizeMax() <= 0L ? "unlimited" : Long.valueOf(this.fileUpload.getSizeMax())) + " bytes)");
        }
        catch (IOException ioe) {
            throw new UWSException(400, (Throwable)ioe, "Incorrect HTTP request: " + ioe.getMessage());
        }
        catch (IllegalArgumentException iae) {
            String confError = iae.getMessage();
            if (this.fileManager.getTmpDirectory() == null) {
                confError = "Missing upload directory!";
            }
            throw new UWSException(500, (Throwable)iae, "Internal Error! Incorrect UPLOAD configuration: " + confError);
        }
        return parameters;
    }

    protected File getFileFromParam(HttpServletRequest request, String parentFile, String inputFileName) {
        Object reqID = request.getAttribute("UWS_REQUEST_ID");
        if (reqID == null || !(reqID instanceof String)) {
            reqID = new Date().getTime();
        }
        char uniq = 'A';
        File f = new File(parentFile, "UPLOAD_" + reqID + uniq + "_" + inputFileName);
        while (f.exists()) {
            uniq = (char)(uniq + '\u0001');
            f = new File(parentFile, "UPLOAD_" + reqID + "_" + inputFileName);
        }
        return f;
    }

    protected void consumeParameter(String name, Object value, Map<String, Object> allParams) {
        if (allParams.containsKey(name) && allParams.get(name) instanceof UploadFile) {
            try {
                ((UploadFile)allParams.get(name)).deleteFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        allParams.put(name, value);
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        return ServletFileUpload.isMultipartContent(request);
    }
}

