/*
 * Decompiled with CFR 0.152.
 */
package it.inaf.ia2.rap.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.inaf.ia2.rap.data.Identity;
import it.inaf.ia2.rap.data.IdentityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class RapUser
implements Serializable {
    private static final long serialVersionUID = -1600342688190507959L;
    private String id;
    private List<Identity> identities = new ArrayList<Identity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Identity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<Identity> identities) {
        this.identities = identities;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public String getDisplayName() {
        Object displayName = null;
        for (Identity identity : this.identities) {
            if (identity.getName() == null || identity.getName().isEmpty() || identity.getSurname() == null || identity.getSurname().isEmpty()) continue;
            displayName = String.format("%s %s", identity.getName(), identity.getSurname());
            if (!identity.isPrimary()) continue;
            break;
        }
        if (displayName == null) {
            displayName = this.getPrimaryEmailAddress();
        }
        LinkedHashSet types = new LinkedHashSet(this.identities.stream().map(i -> {
            if (i.getType() == IdentityType.EDU_GAIN && i.getTypedId().endsWith("@ia2.inaf.it")) {
                return "IA2";
            }
            return i.getType().getValue();
        }).collect(Collectors.toSet()));
        displayName = (String)displayName + String.format(" (%s)", String.join((CharSequence)", ", types));
        return displayName;
    }

    @JsonIgnore
    public String getPrimaryEmailAddress() {
        for (Identity identity : this.identities) {
            if (!identity.isPrimary()) continue;
            return identity.getEmail();
        }
        return null;
    }
}

