
#include "extra_cards.hpp"
#include "cutout.hpp" // struct fits_card needed

#include "io.hpp"

#include <sstream>
#include <iomanip> // setprecision()

using namespace std;

vector<struct fits_card> convert_to_cards(const struct cards card_values)
{
   LOG_trace(__func__);

   const string empty_str;
   string rest_frq_str;

   // E. W. Greisen et al.: Representations of spectral coordinates in FITS
   // paperIII section 3.4.4. Coordinate parameters

   // the rest frequency or wavelength of the spectral-feature :
   // the special floating-valued keywords
   // RESTFRQa (floating-valued),
   // RESTWAVa (floating-valued),
   // Their units are ‘Hz’ and ‘m’
   //
   // Keyword RESTFREQ has been used in previous FITS files
   // and should be recognized as equivalent to RESTFRQ.
   //
   // FIXME what is unit of RESTFREQ key ?

   vector<struct fits_card> new_cards;

   if(card_values.cunit3 == velocity_unit::NONE) return new_cards;

   ostringstream ss;
   ss << std::fixed << std::setprecision(1) << card_values.rest_frq;
   rest_frq_str = ss.str();

   string cunit3_str = to_string(card_values.cunit3);

   struct fits_card card_restfrq{"RESTFRQ", rest_frq_str, "[Hz] key added by vlkb_cutout"};
   struct fits_card card_cunit3 {"CUNIT3",  "'" + cunit3_str + "'",   "key added by vlkb_cutout"};

   // FIXME we (mis)use 0.0 as value when DB entry is empty (2D images)
   // see db-query defult value: row[rest_frequency].as<double>(0.0)
   if(card_values.rest_frq > 0.0) new_cards.push_back(card_restfrq);
   if(!cunit3_str.empty()) new_cards.push_back(card_cunit3);

   return new_cards;
}

