
#include "service_string.hpp"
#include <stdexcept>

using namespace std;

skysystem to_skysystem(std::string str)
{
   if(str.compare("GALACTIC") == 0) return skysystem::GALACTIC;
   else if(str.compare("ICRS") == 0) return skysystem::ICRS;
   else throw invalid_argument("string must be GALACTIC or ICRS but was " + str);
}



specsystem to_specsystem(int i)// special case for legacy interface, remove later
{
   switch(i)
   {
      case 0: return specsystem::NONE;
      case 1: return specsystem::VELO_LSRK;
      case 2: return specsystem::WAVE_Barycentric;
      default: return specsystem::NONE;
   }
}

