#ifndef DATABASE_HPP
#define DATABASE_HPP

#include <vector>
#include <string>

std::string createPubdid(const std::string path, const std::string filename, unsigned int hdunum);

namespace database
{
   void dbInit(const std::string db_uri, const std::string db_schema, const std::string surveys_file);

   void dbAddSurvey(int sid, const std::string groups,
         const std::string obscore_publisher,
         const std::string obscore_access_format,
         const std::string remote_fitsdir,
         const std::string db_uri, const std::string db_schema,
         const std::string fitsdir, int max_hdupos);

   void dbModifyGroups(int sid, const std::string groups,
         const std::string obscore_publisher,
         const std::string db_uri, const std::string db_schema);

   void dbRemoveSurvey(int sid, const std::string db_uri, const std::string db_schema);
   void dbSurveyBounds(/*int sid,*/ const std::string db_uri, const std::string db_schema);
   std::vector<std::string> dbCheck(const std::string db_uri, const std::string db_schema);
   std::vector<std::string> dbListSurveys(const std::string db_uri, const std::string db_schema);
   std::string dbListFiles(int sid, const std::string db_uri, const std::string db_schema, const std::string fitsdir);
   void dbGenCards(int sid, const std::string db_uri, const std::string db_schema,
         const std::string fitsdir, unsigned int max_hdunum);
}

#endif

