#ifndef AST_FRAMESET_HPP
#define AST_FRAMESET_HPP

#include <string>
extern "C" {
#include <ast.h>
}

#include "cutout.hpp" // coordinates needed
#include "ast4vl.hpp" // struct decls needed

#include <array>
#include <vector>
#include <ostream>
#include <string>


namespace ast
{

class frameset
{
   public:
      frameset(std::string header);
      ~frameset();

      bool has_specframe(void);
      bool has_timeaxis(void);

      void set(skysystem skysys);
      void set(specsystem specsys);
      void set(timesystem timesys);

      void set_skysystem(std::string skysys_str);
      void set_specsystem(std::string specsys_str);
      void set_timesystem(std::string timesys_str);

      std::vector<point2d> sky_vertices(void);
      std::vector<Bounds> bounds(void);
      overlap_ranges overlap(coordinates coord);

      void write(std::ostream& ostrm, std::string header);
      void write2(std::string fits_pathname, int hdunum);

      std::ostream& serialize(std::ostream& strm) const;

   private:
      void log_bounds(std::string prefix, int length, double low[], double up[]);
      void log_warnings(const AstFitsChan * fchan);

      AstRegion * create_header_region(void);
      void set_spec_axis(void);
      void set_pol_time_sky_axis(void);
      void log_NAXISn(void);

      void* find_skyframe(void);
      void set_bounds_to_rect(coordinates& coord);
      void assert_valid_state(void);

      /* const*/ int m_NAXIS;
      /* const */std::vector<int> m_NAXISn;
      AstFrameSet * m_hdr_fs;

      // FIXME can be part of state only if no external operation - currently set(skysys) set(specsys) - 
      // causes axis permutation or then spec-axis number needs to be set again
      // NOTE: currently used only in overlap()
      bool m_has_specframe;
      int m_spec_axis;

      bool m_has_stokes_axis;
      int m_stokes_axis;

      bool m_has_time_axis;
      int m_time_axis;

      bool m_has_skyframe;
      int m_sky_lon_axis;
      int m_sky_lat_axis;

      std::vector<char> m_axis_type;//[ AXES_CNT ]; // o=lon a=lat b=spec/band t=time p=pol/stokes
};

}




std::ostream& operator<<(std::ostream& out, const ast::frameset& p);

#endif


