/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import nom.tam.fits.FitsException;
import nom.tam.fits.compress.CloseIS;
import nom.tam.fits.compress.CompressionManager;
import nom.tam.fits.compress.ICompressProvider;

public class BasicCompressProvider
implements ICompressProvider {
    private static final int PRIORITY = 10;
    private static final int COMPRESS_MAGIC_BYTE1 = 31;
    private static final int COMPRESS_MAGIC_BYTE2 = 157;
    private static final Logger LOG = Logger.getLogger(BasicCompressProvider.class.getName());

    private InputStream compressInputStream(InputStream compressed) throws IOException, FitsException {
        try {
            Process proc = new ProcessBuilder("uncompress", "-c").start();
            return new CloseIS(proc, compressed);
        }
        catch (Exception e) {
            ICompressProvider next = CompressionManager.nextCompressionProvider(31, 157, this);
            if (next != null) {
                LOG.warning("Error initiating .Z decompression: " + e.getMessage() + " trieing alternative decompressor");
                return next.decompress(compressed);
            }
            throw new FitsException("Unable to read .Z compressed stream.\nIs `uncompress' in the path?\n:" + e);
        }
    }

    @Override
    public InputStream decompress(InputStream in) throws IOException, FitsException {
        return this.compressInputStream(in);
    }

    @Override
    public int priority() {
        return 10;
    }

    @Override
    public boolean provides(int mag1, int mag2) {
        return mag1 == 31 && mag2 == 157;
    }
}

