
import java.util.logging.Logger;
import java.util.List;
import java.util.ArrayList;

import vo.parameter.*;

class DataLink
{
   private static final Logger LOGGER = Logger.getLogger("DataLink");

   /* DataLink fields */

   String id;
   String accessUrl;   // MX
   String serviceDef;
   String errorMessage;
   String description;  // X
   String semantics;
   String contentType;
   long  contentLength;  // MX

   /* legacy-VLKB fields */

   Inputs inputs;
   String versionString;
   String cut;
   String absCutPathname; // ServeltCutout uses
   int datacubeCount;
   NullValueCount nullVals;
   MCutResult.Cut[] mcutResultArr;


   public DataLink()
   {
      this.nullVals = new NullValueCount();
      this.versionString = Version.asString;
      this.inputs = null;
      this.datacubeCount = 1;
   }


   // used in ServeltCutout
   public DataLink(Settings settings, CutResult cutResult,
         String id, Pos pos, Band band, Time time, Pol pol, boolean countNullValues)
   {
      this.id            = id;
      this.accessUrl     = convertLocalPathnameToRemoteUrl(cutResult.fileName,
            settings.fitsPaths.cutouts(), settings.fitsPaths.cutoutsUrl());
      this.serviceDef    = null;
      this.errorMessage  = null;
      this.description   = "A cutout from " + id;
      // + " by parameters "
      // + pos.toString() + " " + band.toString() + " " + time.toString() + " " + pol.toString();
      this.semantics     = "http://www.ivoa.net/rdf/datalink/core#proc#cutout";
      this.contentType   = "application/fits";
      this.contentLength = cutResult.fileSize;

      // VLKB-extension to DataLink:
      Coord coord = new Coord(pos, band, time, pol, null);
      LOGGER.info(coord.toString());

      this.inputs         = new Inputs(id, coord, countNullValues);
      this.versionString  = Version.asString;
      this.cut            = null;
      this.absCutPathname = cutResult.fileName;
      this.datacubeCount  = 1;
      this.nullVals = ((cutResult.nullValueCount.percent < 0) || (cutResult.nullValueCount.totalCount < 1)) ?
         null : cutResult.nullValueCount;
      this.mcutResultArr  = null;
   }

   // FIXME fake, only to compile MCutout and Merge
   public DataLink(CutResult cutResult)
   {
      this.nullVals = new NullValueCount();

      this.id            = "_PIXEL_BOUNDS"; 
      this.accessUrl     = cutResult.fileName; // FIXME fileName ->> remoteUrl
      this.serviceDef    = null;
      this.errorMessage  = null;
      this.description   = "cutout_from ID";
      this.semantics     = "FIXME find in IVOA docs...";
      this.contentType   = "application/fits"; 
      this.contentLength = cutResult.fileSize;

      // VLKB-extension to DataLink:
      this.inputs         = null;
      this.versionString  = Version.asString;
      this.cut            = null;
      this.absCutPathname = cutResult.fileName;
      this.datacubeCount  = 1;
      this.nullVals       = cutResult.nullValueCount;
      this.mcutResultArr  = null;
   }


   // used in MCutout
   public DataLink(MCutResult cutResult)
   {
      this.nullVals = new NullValueCount();

      this.id            = "_PIXEL_BOUNDS"; 
      this.accessUrl     = cutResult.fileName; // FIXME fileName ->> remoteUrl
      this.serviceDef    = null;
      this.errorMessage  = null;
      this.description   = "cutout_from ID";
      this.semantics     = "FIXME find in IVOA docs...";
      this.contentType   = "application/fits"; 
      this.contentLength = cutResult.fileSize;

      // VLKB-extension to DataLink:
      this.inputs         = null;
      this.versionString  = Version.asString;
      this.cut            = null;
      this.absCutPathname = cutResult.fileName;
      this.datacubeCount  = 1;
      this.nullVals       = null;
      this.mcutResultArr  = cutResult.cutResArr;
   }


   public String convertLocalPathnameToRemoteUrl(String localPathname, String FITScutpath, String FITSRemoteUrlCutouts)
   {
      String fileName = localPathname.replaceAll(FITScutpath + "/", "");
      LOGGER.info("local filename: " + fileName);
      String remotefname = FITSRemoteUrlCutouts + "/" + fileName;
      LOGGER.info("remote url    : " + remotefname);
      return remotefname;
   }

}

